/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang.config;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.ArrayConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClientBuilder;
import software.amazon.kinesis.checkpoint.CheckpointConfig;
import software.amazon.kinesis.common.ConfigsBuilder;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.common.KinesisClientUtil;
import software.amazon.kinesis.coordinator.CoordinatorConfig;
import software.amazon.kinesis.coordinator.Scheduler;
import software.amazon.kinesis.leases.LeaseManagementConfig;
import software.amazon.kinesis.leases.ShardPrioritization;
import software.amazon.kinesis.lifecycle.LifecycleConfig;
import software.amazon.kinesis.metrics.MetricsConfig;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.multilang.config.AwsCredentialsProviderPropertyValueDecoder;
import software.amazon.kinesis.multilang.config.BuilderDynaBean;
import software.amazon.kinesis.multilang.config.ConfigurationSettable;
import software.amazon.kinesis.multilang.config.ConfigurationSettableUtils;
import software.amazon.kinesis.multilang.config.ConfigurationSettables;
import software.amazon.kinesis.multilang.config.FanoutConfigBean;
import software.amazon.kinesis.multilang.config.PollingConfigBean;
import software.amazon.kinesis.multilang.config.RetrievalMode;
import software.amazon.kinesis.processor.ProcessorConfig;
import software.amazon.kinesis.processor.ShardRecordProcessorFactory;
import software.amazon.kinesis.retrieval.RetrievalConfig;
import software.amazon.kinesis.retrieval.polling.PollingConfig;

public class MultiLangDaemonConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MultiLangDaemonConfiguration.class);
    private static final String CREDENTIALS_DEFAULT_SEARCH_PATH = "software.amazon.awssdk.auth.credentials";
    private String applicationName;
    private String streamName;
    private String streamArn;
    @ConfigurationSettable(configurationClass=ConfigsBuilder.class)
    private String tableName;
    private String workerIdentifier = UUID.randomUUID().toString();
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private long failoverTimeMillis;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private Boolean enablePriorityLeaseAssignment;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private Boolean leaseTableDeletionProtectionEnabled;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private Boolean leaseTablePitrEnabled;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private long shardSyncIntervalMillis;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private boolean cleanupLeasesUponShardCompletion;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private boolean ignoreUnexpectedChildShards;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private int maxLeasesForWorker;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private int maxLeasesToStealAtOneTime;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private int initialLeaseTableReadCapacity;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private int initialLeaseTableWriteCapacity;
    @ConfigurationSettables(value={@ConfigurationSettable(configurationClass=LeaseManagementConfig.class, methodName="initialPositionInStream"), @ConfigurationSettable(configurationClass=RetrievalConfig.class)})
    private InitialPositionInStreamExtended initialPositionInStreamExtended;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private int maxLeaseRenewalThreads;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private long listShardsBackoffTimeInMillis;
    @ConfigurationSettable(configurationClass=LeaseManagementConfig.class)
    private int maxListShardsRetryAttempts;
    @ConfigurationSettable(configurationClass=ProcessorConfig.class)
    private boolean callProcessRecordsEvenForEmptyRecordList;
    @ConfigurationSettable(configurationClass=CoordinatorConfig.class)
    private long parentShardPollIntervalMillis;
    @ConfigurationSettable(configurationClass=CoordinatorConfig.class)
    private ShardPrioritization shardPrioritization;
    @ConfigurationSettable(configurationClass=CoordinatorConfig.class)
    private boolean skipShardSyncAtWorkerInitializationIfLeasesExist;
    @ConfigurationSettable(configurationClass=CoordinatorConfig.class)
    private long schedulerInitializationBackoffTimeMillis;
    @ConfigurationSettable(configurationClass=LifecycleConfig.class)
    private long taskBackoffTimeMillis;
    @ConfigurationSettable(configurationClass=MetricsConfig.class)
    private long metricsBufferTimeMillis;
    @ConfigurationSettable(configurationClass=MetricsConfig.class)
    private int metricsMaxQueueSize;
    @ConfigurationSettable(configurationClass=MetricsConfig.class)
    private MetricsLevel metricsLevel;
    @ConfigurationSettable(configurationClass=LifecycleConfig.class, convertToOptional=true)
    private Long logWarningForTaskAfterMillis;
    @ConfigurationSettable(configurationClass=MetricsConfig.class)
    private Set<String> metricsEnabledDimensions;
    private RetrievalMode retrievalMode = RetrievalMode.DEFAULT;
    private final FanoutConfigBean fanoutConfig = new FanoutConfigBean();
    private final PollingConfigBean pollingConfig = new PollingConfigBean();
    private boolean validateSequenceNumberBeforeCheckpointing;
    private long shutdownGraceMillis;
    private Integer timeoutInSeconds;
    private final BuilderDynaBean kinesisCredentialsProvider;
    private final BuilderDynaBean dynamoDBCredentialsProvider;
    private final BuilderDynaBean cloudWatchCredentialsProvider;
    private final BuilderDynaBean kinesisClient;
    private final BuilderDynaBean dynamoDbClient;
    private final BuilderDynaBean cloudWatchClient;
    private final BeanUtilsBean utilsBean;
    private final ConvertUtilsBean convertUtilsBean;

    public void setWorkerId(String workerId) {
        this.workerIdentifier = workerId;
    }

    public InitialPositionInStream getInitialPositionInStream() {
        if (this.initialPositionInStreamExtended != null) {
            return this.initialPositionInStreamExtended.getInitialPositionInStream();
        }
        return null;
    }

    public void setInitialPositionInStream(InitialPositionInStream initialPositionInStream) {
        this.initialPositionInStreamExtended = InitialPositionInStreamExtended.newInitialPosition((InitialPositionInStream)initialPositionInStream);
    }

    public String[] getMetricsEnabledDimensions() {
        return this.metricsEnabledDimensions.toArray(new String[0]);
    }

    public void setMetricsEnabledDimensions(String[] dimensions) {
        this.metricsEnabledDimensions = new HashSet<String>(Arrays.asList(dimensions));
    }

    public void setAwsCredentialsProvider(String providerString) {
        this.kinesisCredentialsProvider.set("", providerString);
    }

    public void setAwsCredentialsProviderDynamoDB(String providerString) {
        this.dynamoDBCredentialsProvider.set("", providerString);
    }

    public void setAwsCredentialsProviderCloudWatch(String providerString) {
        this.cloudWatchCredentialsProvider.set("", providerString);
    }

    public MultiLangDaemonConfiguration(BeanUtilsBean utilsBean, ConvertUtilsBean convertUtilsBean) {
        this.utilsBean = utilsBean;
        this.convertUtilsBean = convertUtilsBean;
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                Date date = new Date(Long.parseLong(value.toString()) * 1000L);
                return type.cast(InitialPositionInStreamExtended.newInitialPositionAtTimestamp((Date)date));
            }
        }, InitialPositionInStreamExtended.class);
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                return type.cast(MetricsLevel.valueOf((String)value.toString().toUpperCase()));
            }
        }, MetricsLevel.class);
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                return type.cast(InitialPositionInStream.valueOf((String)value.toString().toUpperCase()));
            }
        }, InitialPositionInStream.class);
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                return type.cast(URI.create(value.toString()));
            }
        }, URI.class);
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                return type.cast((Object)RetrievalMode.from(value.toString()));
            }
        }, RetrievalMode.class);
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                return type.cast(Region.of((String)value.toString()));
            }
        }, Region.class);
        ArrayConverter arrayConverter = new ArrayConverter(String[].class, (Converter)new StringConverter());
        arrayConverter.setDelimiter(',');
        convertUtilsBean.register((Converter)arrayConverter, String[].class);
        AwsCredentialsProviderPropertyValueDecoder credentialsDecoder = new AwsCredentialsProviderPropertyValueDecoder();
        Function<String, Object> converter = credentialsDecoder::decodeValue;
        this.kinesisCredentialsProvider = new BuilderDynaBean(AwsCredentialsProvider.class, convertUtilsBean, converter, CREDENTIALS_DEFAULT_SEARCH_PATH);
        this.dynamoDBCredentialsProvider = new BuilderDynaBean(AwsCredentialsProvider.class, convertUtilsBean, converter, CREDENTIALS_DEFAULT_SEARCH_PATH);
        this.cloudWatchCredentialsProvider = new BuilderDynaBean(AwsCredentialsProvider.class, convertUtilsBean, converter, CREDENTIALS_DEFAULT_SEARCH_PATH);
        this.kinesisClient = new BuilderDynaBean(KinesisAsyncClient.class, convertUtilsBean, new String[0]);
        this.dynamoDbClient = new BuilderDynaBean(DynamoDbAsyncClient.class, convertUtilsBean, new String[0]);
        this.cloudWatchClient = new BuilderDynaBean(CloudWatchAsyncClient.class, convertUtilsBean, new String[0]);
    }

    private void setRegionForClient(String name, BuilderDynaBean client, Region region) {
        try {
            this.utilsBean.setProperty((Object)client, "region", (Object)region);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Failed to set region on {}", (Object)name, (Object)e);
            throw new IllegalStateException(e);
        }
    }

    public void setRegionName(Region region) {
        this.setRegionForClient("kinesisClient", this.kinesisClient, region);
        this.setRegionForClient("dynamoDbClient", this.dynamoDbClient, region);
        this.setRegionForClient("cloudWatchClient", this.cloudWatchClient, region);
    }

    private void setEndpointForClient(String name, BuilderDynaBean client, String endpoint) {
        try {
            this.utilsBean.setProperty((Object)client, "endpointOverride", (Object)endpoint);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Failed to set endpoint on {}", (Object)name, (Object)e);
            throw new IllegalStateException(e);
        }
    }

    public void setKinesisEndpoint(String endpoint) {
        this.setEndpointForClient("kinesisClient", this.kinesisClient, endpoint);
    }

    public void setDynamoDBEndpoint(String endpoint) {
        this.setEndpointForClient("dynamoDbClient", this.dynamoDbClient, endpoint);
    }

    private AwsCredentialsProvider resolveCredentials(BuilderDynaBean credsBuilder) {
        if (!credsBuilder.isDirty()) {
            return null;
        }
        return credsBuilder.build(AwsCredentialsProvider.class, new Function[0]);
    }

    private void updateCredentials(BuilderDynaBean toUpdate, AwsCredentialsProvider primary, AwsCredentialsProvider secondary) {
        if (toUpdate.hasValue("credentialsProvider")) {
            return;
        }
        try {
            if (primary != null) {
                this.utilsBean.setProperty((Object)toUpdate, "credentialsProvider", (Object)primary);
            } else if (secondary != null) {
                this.utilsBean.setProperty((Object)toUpdate, "credentialsProvider", (Object)secondary);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Unable to update credentials", e);
        }
    }

    private void addConfigObjects(Map<Class<?>, Object> configObjects, Object ... toAdd) {
        for (Object obj : toAdd) {
            configObjects.put(obj.getClass(), obj);
        }
    }

    private void resolveFields(Map<Class<?>, Object> configObjects, Set<Class<?>> restrictTo, Set<Class<?>> skipIf) {
        ConfigurationSettableUtils.resolveFields(this, configObjects, restrictTo, skipIf);
    }

    private void handleRetrievalConfig(RetrievalConfig retrievalConfig, ConfigsBuilder configsBuilder) {
        retrievalConfig.retrievalSpecificConfig(this.retrievalMode.builder(this).build(configsBuilder.kinesisClient(), this));
    }

    private Object adjustKinesisHttpConfiguration(Object builderObj) {
        if (builderObj instanceof KinesisAsyncClientBuilder) {
            KinesisAsyncClientBuilder builder = (KinesisAsyncClientBuilder)builderObj;
            return builder.applyMutation(KinesisClientUtil::adjustKinesisClientBuilder);
        }
        return builderObj;
    }

    ResolvedConfiguration resolvedConfiguration(ShardRecordProcessorFactory shardRecordProcessorFactory) {
        AwsCredentialsProvider kinesisCreds = this.resolveCredentials(this.kinesisCredentialsProvider);
        AwsCredentialsProvider dynamoDbCreds = this.resolveCredentials(this.dynamoDBCredentialsProvider);
        AwsCredentialsProvider cloudwatchCreds = this.resolveCredentials(this.cloudWatchCredentialsProvider);
        this.updateCredentials(this.kinesisClient, kinesisCreds, kinesisCreds);
        this.updateCredentials(this.dynamoDbClient, dynamoDbCreds, kinesisCreds);
        this.updateCredentials(this.cloudWatchClient, cloudwatchCreds, kinesisCreds);
        KinesisAsyncClient kinesisAsyncClient = this.kinesisClient.build(KinesisAsyncClient.class, this::adjustKinesisHttpConfiguration);
        DynamoDbAsyncClient dynamoDbAsyncClient = this.dynamoDbClient.build(DynamoDbAsyncClient.class, new Function[0]);
        CloudWatchAsyncClient cloudWatchAsyncClient = this.cloudWatchClient.build(CloudWatchAsyncClient.class, new Function[0]);
        ConfigsBuilder configsBuilder = new ConfigsBuilder(this.streamName, this.applicationName, kinesisAsyncClient, dynamoDbAsyncClient, cloudWatchAsyncClient, this.workerIdentifier, shardRecordProcessorFactory);
        HashMap configObjects = new HashMap();
        this.addConfigObjects(configObjects, configsBuilder);
        this.resolveFields(configObjects, Collections.singleton(ConfigsBuilder.class), Collections.singleton(PollingConfig.class));
        CoordinatorConfig coordinatorConfig = configsBuilder.coordinatorConfig();
        CheckpointConfig checkpointConfig = configsBuilder.checkpointConfig();
        LeaseManagementConfig leaseManagementConfig = configsBuilder.leaseManagementConfig();
        LifecycleConfig lifecycleConfig = configsBuilder.lifecycleConfig();
        MetricsConfig metricsConfig = configsBuilder.metricsConfig();
        ProcessorConfig processorConfig = configsBuilder.processorConfig();
        RetrievalConfig retrievalConfig = configsBuilder.retrievalConfig();
        this.addConfigObjects(configObjects, coordinatorConfig, checkpointConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig);
        this.handleRetrievalConfig(retrievalConfig, configsBuilder);
        this.resolveFields(configObjects, null, new HashSet(Arrays.asList(ConfigsBuilder.class, PollingConfig.class)));
        return new ResolvedConfiguration(coordinatorConfig, checkpointConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig);
    }

    public Scheduler build(ShardRecordProcessorFactory shardRecordProcessorFactory) {
        return this.resolvedConfiguration(shardRecordProcessorFactory).build();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getStreamArn() {
        return this.streamArn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getWorkerIdentifier() {
        return this.workerIdentifier;
    }

    public long getFailoverTimeMillis() {
        return this.failoverTimeMillis;
    }

    public Boolean getEnablePriorityLeaseAssignment() {
        return this.enablePriorityLeaseAssignment;
    }

    public Boolean getLeaseTableDeletionProtectionEnabled() {
        return this.leaseTableDeletionProtectionEnabled;
    }

    public Boolean getLeaseTablePitrEnabled() {
        return this.leaseTablePitrEnabled;
    }

    public long getShardSyncIntervalMillis() {
        return this.shardSyncIntervalMillis;
    }

    public boolean isCleanupLeasesUponShardCompletion() {
        return this.cleanupLeasesUponShardCompletion;
    }

    public boolean isIgnoreUnexpectedChildShards() {
        return this.ignoreUnexpectedChildShards;
    }

    public int getMaxLeasesForWorker() {
        return this.maxLeasesForWorker;
    }

    public int getMaxLeasesToStealAtOneTime() {
        return this.maxLeasesToStealAtOneTime;
    }

    public int getInitialLeaseTableReadCapacity() {
        return this.initialLeaseTableReadCapacity;
    }

    public int getInitialLeaseTableWriteCapacity() {
        return this.initialLeaseTableWriteCapacity;
    }

    public InitialPositionInStreamExtended getInitialPositionInStreamExtended() {
        return this.initialPositionInStreamExtended;
    }

    public int getMaxLeaseRenewalThreads() {
        return this.maxLeaseRenewalThreads;
    }

    public long getListShardsBackoffTimeInMillis() {
        return this.listShardsBackoffTimeInMillis;
    }

    public int getMaxListShardsRetryAttempts() {
        return this.maxListShardsRetryAttempts;
    }

    public boolean isCallProcessRecordsEvenForEmptyRecordList() {
        return this.callProcessRecordsEvenForEmptyRecordList;
    }

    public long getParentShardPollIntervalMillis() {
        return this.parentShardPollIntervalMillis;
    }

    public ShardPrioritization getShardPrioritization() {
        return this.shardPrioritization;
    }

    public boolean isSkipShardSyncAtWorkerInitializationIfLeasesExist() {
        return this.skipShardSyncAtWorkerInitializationIfLeasesExist;
    }

    public long getSchedulerInitializationBackoffTimeMillis() {
        return this.schedulerInitializationBackoffTimeMillis;
    }

    public long getTaskBackoffTimeMillis() {
        return this.taskBackoffTimeMillis;
    }

    public long getMetricsBufferTimeMillis() {
        return this.metricsBufferTimeMillis;
    }

    public int getMetricsMaxQueueSize() {
        return this.metricsMaxQueueSize;
    }

    public MetricsLevel getMetricsLevel() {
        return this.metricsLevel;
    }

    public Long getLogWarningForTaskAfterMillis() {
        return this.logWarningForTaskAfterMillis;
    }

    public RetrievalMode getRetrievalMode() {
        return this.retrievalMode;
    }

    public FanoutConfigBean getFanoutConfig() {
        return this.fanoutConfig;
    }

    public PollingConfigBean getPollingConfig() {
        return this.pollingConfig;
    }

    public boolean isValidateSequenceNumberBeforeCheckpointing() {
        return this.validateSequenceNumberBeforeCheckpointing;
    }

    public long getShutdownGraceMillis() {
        return this.shutdownGraceMillis;
    }

    public Integer getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public BuilderDynaBean getKinesisCredentialsProvider() {
        return this.kinesisCredentialsProvider;
    }

    public BuilderDynaBean getDynamoDBCredentialsProvider() {
        return this.dynamoDBCredentialsProvider;
    }

    public BuilderDynaBean getCloudWatchCredentialsProvider() {
        return this.cloudWatchCredentialsProvider;
    }

    public BuilderDynaBean getKinesisClient() {
        return this.kinesisClient;
    }

    public BuilderDynaBean getDynamoDbClient() {
        return this.dynamoDbClient;
    }

    public BuilderDynaBean getCloudWatchClient() {
        return this.cloudWatchClient;
    }

    public BeanUtilsBean getUtilsBean() {
        return this.utilsBean;
    }

    public ConvertUtilsBean getConvertUtilsBean() {
        return this.convertUtilsBean;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public void setStreamArn(String streamArn) {
        this.streamArn = streamArn;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setWorkerIdentifier(String workerIdentifier) {
        this.workerIdentifier = workerIdentifier;
    }

    public void setFailoverTimeMillis(long failoverTimeMillis) {
        this.failoverTimeMillis = failoverTimeMillis;
    }

    public void setEnablePriorityLeaseAssignment(Boolean enablePriorityLeaseAssignment) {
        this.enablePriorityLeaseAssignment = enablePriorityLeaseAssignment;
    }

    public void setLeaseTableDeletionProtectionEnabled(Boolean leaseTableDeletionProtectionEnabled) {
        this.leaseTableDeletionProtectionEnabled = leaseTableDeletionProtectionEnabled;
    }

    public void setLeaseTablePitrEnabled(Boolean leaseTablePitrEnabled) {
        this.leaseTablePitrEnabled = leaseTablePitrEnabled;
    }

    public void setShardSyncIntervalMillis(long shardSyncIntervalMillis) {
        this.shardSyncIntervalMillis = shardSyncIntervalMillis;
    }

    public void setCleanupLeasesUponShardCompletion(boolean cleanupLeasesUponShardCompletion) {
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
    }

    public void setIgnoreUnexpectedChildShards(boolean ignoreUnexpectedChildShards) {
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
    }

    public void setMaxLeasesForWorker(int maxLeasesForWorker) {
        this.maxLeasesForWorker = maxLeasesForWorker;
    }

    public void setMaxLeasesToStealAtOneTime(int maxLeasesToStealAtOneTime) {
        this.maxLeasesToStealAtOneTime = maxLeasesToStealAtOneTime;
    }

    public void setInitialLeaseTableReadCapacity(int initialLeaseTableReadCapacity) {
        this.initialLeaseTableReadCapacity = initialLeaseTableReadCapacity;
    }

    public void setInitialLeaseTableWriteCapacity(int initialLeaseTableWriteCapacity) {
        this.initialLeaseTableWriteCapacity = initialLeaseTableWriteCapacity;
    }

    public void setInitialPositionInStreamExtended(InitialPositionInStreamExtended initialPositionInStreamExtended) {
        this.initialPositionInStreamExtended = initialPositionInStreamExtended;
    }

    public void setMaxLeaseRenewalThreads(int maxLeaseRenewalThreads) {
        this.maxLeaseRenewalThreads = maxLeaseRenewalThreads;
    }

    public void setListShardsBackoffTimeInMillis(long listShardsBackoffTimeInMillis) {
        this.listShardsBackoffTimeInMillis = listShardsBackoffTimeInMillis;
    }

    public void setMaxListShardsRetryAttempts(int maxListShardsRetryAttempts) {
        this.maxListShardsRetryAttempts = maxListShardsRetryAttempts;
    }

    public void setCallProcessRecordsEvenForEmptyRecordList(boolean callProcessRecordsEvenForEmptyRecordList) {
        this.callProcessRecordsEvenForEmptyRecordList = callProcessRecordsEvenForEmptyRecordList;
    }

    public void setParentShardPollIntervalMillis(long parentShardPollIntervalMillis) {
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
    }

    public void setShardPrioritization(ShardPrioritization shardPrioritization) {
        this.shardPrioritization = shardPrioritization;
    }

    public void setSkipShardSyncAtWorkerInitializationIfLeasesExist(boolean skipShardSyncAtWorkerInitializationIfLeasesExist) {
        this.skipShardSyncAtWorkerInitializationIfLeasesExist = skipShardSyncAtWorkerInitializationIfLeasesExist;
    }

    public void setSchedulerInitializationBackoffTimeMillis(long schedulerInitializationBackoffTimeMillis) {
        this.schedulerInitializationBackoffTimeMillis = schedulerInitializationBackoffTimeMillis;
    }

    public void setTaskBackoffTimeMillis(long taskBackoffTimeMillis) {
        this.taskBackoffTimeMillis = taskBackoffTimeMillis;
    }

    public void setMetricsBufferTimeMillis(long metricsBufferTimeMillis) {
        this.metricsBufferTimeMillis = metricsBufferTimeMillis;
    }

    public void setMetricsMaxQueueSize(int metricsMaxQueueSize) {
        this.metricsMaxQueueSize = metricsMaxQueueSize;
    }

    public void setMetricsLevel(MetricsLevel metricsLevel) {
        this.metricsLevel = metricsLevel;
    }

    public void setLogWarningForTaskAfterMillis(Long logWarningForTaskAfterMillis) {
        this.logWarningForTaskAfterMillis = logWarningForTaskAfterMillis;
    }

    public void setRetrievalMode(RetrievalMode retrievalMode) {
        this.retrievalMode = retrievalMode;
    }

    public void setValidateSequenceNumberBeforeCheckpointing(boolean validateSequenceNumberBeforeCheckpointing) {
        this.validateSequenceNumberBeforeCheckpointing = validateSequenceNumberBeforeCheckpointing;
    }

    public void setShutdownGraceMillis(long shutdownGraceMillis) {
        this.shutdownGraceMillis = shutdownGraceMillis;
    }

    public void setTimeoutInSeconds(Integer timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public Integer getRetryGetRecordsInSeconds() {
        return this.getPollingConfig().getRetryGetRecordsInSeconds();
    }

    public void setRetryGetRecordsInSeconds(Integer value) {
        this.getPollingConfig().setRetryGetRecordsInSeconds(value);
    }

    public Integer getMaxGetRecordsThreadPool() {
        return this.getPollingConfig().getMaxGetRecordsThreadPool();
    }

    public void setMaxGetRecordsThreadPool(Integer value) {
        this.getPollingConfig().setMaxGetRecordsThreadPool(value);
    }

    public long getIdleTimeBetweenReadsInMillis() {
        return this.getPollingConfig().getIdleTimeBetweenReadsInMillis();
    }

    public void setIdleTimeBetweenReadsInMillis(long value) {
        this.getPollingConfig().setIdleTimeBetweenReadsInMillis(value);
    }

    public int getMaxRecords() {
        return this.getPollingConfig().getMaxRecords();
    }

    public void setMaxRecords(int value) {
        this.getPollingConfig().setMaxRecords(value);
    }

    static class ResolvedConfiguration {
        final CoordinatorConfig coordinatorConfig;
        final CheckpointConfig checkpointConfig;
        final LeaseManagementConfig leaseManagementConfig;
        final LifecycleConfig lifecycleConfig;
        final MetricsConfig metricsConfig;
        final ProcessorConfig processorConfig;
        final RetrievalConfig retrievalConfig;

        public Scheduler build() {
            return new Scheduler(this.checkpointConfig, this.coordinatorConfig, this.leaseManagementConfig, this.lifecycleConfig, this.metricsConfig, this.processorConfig, this.retrievalConfig);
        }

        public ResolvedConfiguration(CoordinatorConfig coordinatorConfig, CheckpointConfig checkpointConfig, LeaseManagementConfig leaseManagementConfig, LifecycleConfig lifecycleConfig, MetricsConfig metricsConfig, ProcessorConfig processorConfig, RetrievalConfig retrievalConfig) {
            this.coordinatorConfig = coordinatorConfig;
            this.checkpointConfig = checkpointConfig;
            this.leaseManagementConfig = leaseManagementConfig;
            this.lifecycleConfig = lifecycleConfig;
            this.metricsConfig = metricsConfig;
            this.processorConfig = processorConfig;
            this.retrievalConfig = retrievalConfig;
        }

        public CoordinatorConfig getCoordinatorConfig() {
            return this.coordinatorConfig;
        }

        public CheckpointConfig getCheckpointConfig() {
            return this.checkpointConfig;
        }

        public LeaseManagementConfig getLeaseManagementConfig() {
            return this.leaseManagementConfig;
        }

        public LifecycleConfig getLifecycleConfig() {
            return this.lifecycleConfig;
        }

        public MetricsConfig getMetricsConfig() {
            return this.metricsConfig;
        }

        public ProcessorConfig getProcessorConfig() {
            return this.processorConfig;
        }

        public RetrievalConfig getRetrievalConfig() {
            return this.retrievalConfig;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResolvedConfiguration)) {
                return false;
            }
            ResolvedConfiguration other = (ResolvedConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CoordinatorConfig this$coordinatorConfig = this.getCoordinatorConfig();
            CoordinatorConfig other$coordinatorConfig = other.getCoordinatorConfig();
            if (this$coordinatorConfig == null ? other$coordinatorConfig != null : !this$coordinatorConfig.equals(other$coordinatorConfig)) {
                return false;
            }
            CheckpointConfig this$checkpointConfig = this.getCheckpointConfig();
            CheckpointConfig other$checkpointConfig = other.getCheckpointConfig();
            if (this$checkpointConfig == null ? other$checkpointConfig != null : !this$checkpointConfig.equals(other$checkpointConfig)) {
                return false;
            }
            LeaseManagementConfig this$leaseManagementConfig = this.getLeaseManagementConfig();
            LeaseManagementConfig other$leaseManagementConfig = other.getLeaseManagementConfig();
            if (this$leaseManagementConfig == null ? other$leaseManagementConfig != null : !this$leaseManagementConfig.equals(other$leaseManagementConfig)) {
                return false;
            }
            LifecycleConfig this$lifecycleConfig = this.getLifecycleConfig();
            LifecycleConfig other$lifecycleConfig = other.getLifecycleConfig();
            if (this$lifecycleConfig == null ? other$lifecycleConfig != null : !this$lifecycleConfig.equals(other$lifecycleConfig)) {
                return false;
            }
            MetricsConfig this$metricsConfig = this.getMetricsConfig();
            MetricsConfig other$metricsConfig = other.getMetricsConfig();
            if (this$metricsConfig == null ? other$metricsConfig != null : !this$metricsConfig.equals(other$metricsConfig)) {
                return false;
            }
            ProcessorConfig this$processorConfig = this.getProcessorConfig();
            ProcessorConfig other$processorConfig = other.getProcessorConfig();
            if (this$processorConfig == null ? other$processorConfig != null : !this$processorConfig.equals(other$processorConfig)) {
                return false;
            }
            RetrievalConfig this$retrievalConfig = this.getRetrievalConfig();
            RetrievalConfig other$retrievalConfig = other.getRetrievalConfig();
            return !(this$retrievalConfig == null ? other$retrievalConfig != null : !this$retrievalConfig.equals(other$retrievalConfig));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResolvedConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CoordinatorConfig $coordinatorConfig = this.getCoordinatorConfig();
            result = result * 59 + ($coordinatorConfig == null ? 43 : $coordinatorConfig.hashCode());
            CheckpointConfig $checkpointConfig = this.getCheckpointConfig();
            result = result * 59 + ($checkpointConfig == null ? 43 : $checkpointConfig.hashCode());
            LeaseManagementConfig $leaseManagementConfig = this.getLeaseManagementConfig();
            result = result * 59 + ($leaseManagementConfig == null ? 43 : $leaseManagementConfig.hashCode());
            LifecycleConfig $lifecycleConfig = this.getLifecycleConfig();
            result = result * 59 + ($lifecycleConfig == null ? 43 : $lifecycleConfig.hashCode());
            MetricsConfig $metricsConfig = this.getMetricsConfig();
            result = result * 59 + ($metricsConfig == null ? 43 : $metricsConfig.hashCode());
            ProcessorConfig $processorConfig = this.getProcessorConfig();
            result = result * 59 + ($processorConfig == null ? 43 : $processorConfig.hashCode());
            RetrievalConfig $retrievalConfig = this.getRetrievalConfig();
            result = result * 59 + ($retrievalConfig == null ? 43 : $retrievalConfig.hashCode());
            return result;
        }

        public String toString() {
            return "MultiLangDaemonConfiguration.ResolvedConfiguration(coordinatorConfig=" + this.getCoordinatorConfig() + ", checkpointConfig=" + this.getCheckpointConfig() + ", leaseManagementConfig=" + this.getLeaseManagementConfig() + ", lifecycleConfig=" + this.getLifecycleConfig() + ", metricsConfig=" + this.getMetricsConfig() + ", processorConfig=" + this.getProcessorConfig() + ", retrievalConfig=" + this.getRetrievalConfig() + ")";
        }
    }
}

