/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class DynaBeanBuilderUtils {
    static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static Object invokeOrFail(Method method, Object onObject, Object ... arguments) {
        try {
            return method.invoke(onObject, arguments);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isBuilderOrCreate(Class<?> clazz) {
        Method buildMethod = null;
        try {
            buildMethod = clazz.getMethod("builder", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        boolean hasCreate = Arrays.stream(clazz.getMethods()).anyMatch(m -> "create".equals(m.getName()) && m.getReturnType().isAssignableFrom(clazz));
        return buildMethod != null || hasCreate;
    }
}

