/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.kinesis.multilang.auth.KclStsAssumeRoleCredentialsProvider;
import software.amazon.kinesis.multilang.config.IPropertyValueDecoder;

class AwsCredentialsProviderPropertyValueDecoder
implements IPropertyValueDecoder<AwsCredentialsProvider> {
    private static final Logger log = LoggerFactory.getLogger(AwsCredentialsProviderPropertyValueDecoder.class);
    private static final String LIST_DELIMITER = ",";
    private static final String ARG_DELIMITER = "|";

    AwsCredentialsProviderPropertyValueDecoder() {
    }

    @Override
    public AwsCredentialsProvider decodeValue(String value) {
        if (value != null) {
            List<String> providerNames = AwsCredentialsProviderPropertyValueDecoder.getProviderNames(value);
            List<AwsCredentialsProvider> providers = AwsCredentialsProviderPropertyValueDecoder.getValidCredentialsProviders(providerNames);
            AwsCredentialsProvider[] ps = new AwsCredentialsProvider[providers.size()];
            providers.toArray(ps);
            if (providers.isEmpty()) {
                log.warn("Unable to construct any provider with name {}", (Object)value);
                log.warn("Please verify that all AwsCredentialsProvider properties are passed correctly");
            }
            return AwsCredentialsProviderChain.builder().credentialsProviders(providers).build();
        }
        throw new IllegalArgumentException("Property AwsCredentialsProvider is missing.");
    }

    @Override
    public List<Class<AwsCredentialsProvider>> getSupportedTypes() {
        return Collections.singletonList(AwsCredentialsProvider.class);
    }

    private static List<AwsCredentialsProvider> getValidCredentialsProviders(List<String> providerNames) {
        ArrayList<AwsCredentialsProvider> credentialsProviders = new ArrayList<AwsCredentialsProvider>();
        for (String providerName : providerNames) {
            String[] nameAndArgs = providerName.split("\\|");
            Class<? extends AwsCredentialsProvider> clazz = AwsCredentialsProviderPropertyValueDecoder.getClass(nameAndArgs[0]);
            if (clazz == null) continue;
            log.info("Attempting to construct {}", clazz);
            String[] varargs = nameAndArgs.length > 1 ? Arrays.copyOfRange(nameAndArgs, 1, nameAndArgs.length) : new String[]{};
            AwsCredentialsProvider provider = AwsCredentialsProviderPropertyValueDecoder.tryConstructor(providerName, clazz, varargs);
            if (provider == null) {
                provider = AwsCredentialsProviderPropertyValueDecoder.tryCreate(providerName, clazz, varargs);
            }
            if (provider == null) continue;
            log.info("Provider constructed successfully: {}", (Object)provider);
            credentialsProviders.add(provider);
        }
        return credentialsProviders;
    }

    private static AwsCredentialsProvider tryConstructor(String providerName, Class<? extends AwsCredentialsProvider> clazz, String[] varargs) {
        AwsCredentialsProvider provider = AwsCredentialsProviderPropertyValueDecoder.constructProvider(providerName, () -> AwsCredentialsProviderPropertyValueDecoder.getConstructorWithVarArgs(clazz, varargs));
        if (provider == null) {
            provider = AwsCredentialsProviderPropertyValueDecoder.constructProvider(providerName, () -> AwsCredentialsProviderPropertyValueDecoder.getConstructorWithArgs(clazz, varargs));
        }
        if (provider == null) {
            provider = AwsCredentialsProviderPropertyValueDecoder.constructProvider(providerName, clazz::newInstance);
        }
        return provider;
    }

    private static AwsCredentialsProvider tryCreate(String providerName, Class<? extends AwsCredentialsProvider> clazz, String[] varargs) {
        AwsCredentialsProvider provider = AwsCredentialsProviderPropertyValueDecoder.constructProvider(providerName, () -> AwsCredentialsProviderPropertyValueDecoder.getCreateMethod(clazz, new Object[]{varargs}));
        if (provider == null) {
            provider = AwsCredentialsProviderPropertyValueDecoder.constructProvider(providerName, () -> AwsCredentialsProviderPropertyValueDecoder.getCreateMethod(clazz, varargs));
        }
        if (provider == null) {
            provider = AwsCredentialsProviderPropertyValueDecoder.constructProvider(providerName, () -> AwsCredentialsProviderPropertyValueDecoder.getCreateMethod(clazz, new Object[0]));
        }
        return provider;
    }

    private static AwsCredentialsProvider getConstructorWithVarArgs(Class<? extends AwsCredentialsProvider> clazz, String[] varargs) {
        try {
            return clazz.getConstructor(String[].class).newInstance(new Object[]{varargs});
        }
        catch (Exception e) {
            return null;
        }
    }

    private static AwsCredentialsProvider getConstructorWithArgs(Class<? extends AwsCredentialsProvider> clazz, String[] varargs) {
        try {
            Object[] argTypes = new Class[varargs.length];
            Arrays.fill(argTypes, String.class);
            return clazz.getConstructor((Class<?>[])argTypes).newInstance(varargs);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static AwsCredentialsProvider getCreateMethod(Class<? extends AwsCredentialsProvider> clazz, Object ... args) {
        try {
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
            Method createMethod = clazz.getDeclaredMethod("create", argTypes);
            if (Modifier.isStatic(createMethod.getModifiers())) {
                return clazz.cast(createMethod.invoke(null, args));
            }
            log.warn("Found non-static create() method in {}", (Object)clazz.getName());
        }
        catch (NoSuchMethodException argTypes) {
        }
        catch (Exception e) {
            log.warn("Failed to invoke create() method in {}", (Object)clazz.getName(), (Object)e);
        }
        return null;
    }

    private static Class<? extends AwsCredentialsProvider> getClass(String providerName) {
        if (providerName.equals(StsAssumeRoleCredentialsProvider.class.getSimpleName()) || providerName.equals(StsAssumeRoleCredentialsProvider.class.getName())) {
            providerName = KclStsAssumeRoleCredentialsProvider.class.getName();
        }
        try {
            Class<?> c = Class.forName(providerName);
            if (!AwsCredentialsProvider.class.isAssignableFrom(c)) {
                return null;
            }
            return c;
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    private static List<String> getProviderNames(String property) {
        String[] elements = property.split(LIST_DELIMITER);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < elements.length; ++i) {
            String string = elements[i].trim();
            if (string.isEmpty()) continue;
            result.addAll(AwsCredentialsProviderPropertyValueDecoder.getPossibleFullClassNames(string));
        }
        return result;
    }

    private static List<String> getPossibleFullClassNames(String provider) {
        return Stream.of("software.amazon.kinesis.multilang.auth.", "software.amazon.awssdk.auth.credentials.", "").map(prefix -> prefix + provider).collect(Collectors.toList());
    }

    private static <T extends AwsCredentialsProvider> T constructProvider(String providerName, CredentialsProviderConstructor<T> constructor) {
        try {
            return constructor.construct();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException exception) {
            return null;
        }
    }

    @FunctionalInterface
    private static interface CredentialsProviderConstructor<T extends AwsCredentialsProvider> {
        public T construct() throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException;
    }
}

