/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import lombok.NonNull;
import software.amazon.kinesis.retrieval.KinesisClientRecord;

public class JsonFriendlyRecord {
    private byte[] data;
    private String partitionKey;
    private String sequenceNumber;
    private Long approximateArrivalTimestamp;
    private Long subSequenceNumber;
    public static String ACTION = "record";

    public static JsonFriendlyRecord fromKinesisClientRecord(@NonNull KinesisClientRecord record) {
        byte[] data;
        if (record == null) {
            throw new NullPointerException("record is marked non-null but is null");
        }
        if (record.data() == null) {
            data = null;
        } else if (record.data().hasArray()) {
            data = record.data().array();
        } else {
            data = new byte[record.data().limit()];
            record.data().get(data);
        }
        Long approximateArrival = record.approximateArrivalTimestamp() == null ? null : Long.valueOf(record.approximateArrivalTimestamp().toEpochMilli());
        return new JsonFriendlyRecord(data, record.partitionKey(), record.sequenceNumber(), approximateArrival, record.subSequenceNumber());
    }

    @JsonProperty
    public String getAction() {
        return ACTION;
    }

    public JsonFriendlyRecord() {
    }

    public JsonFriendlyRecord(byte[] data, String partitionKey, String sequenceNumber, Long approximateArrivalTimestamp, Long subSequenceNumber) {
        this.data = data;
        this.partitionKey = partitionKey;
        this.sequenceNumber = sequenceNumber;
        this.approximateArrivalTimestamp = approximateArrivalTimestamp;
        this.subSequenceNumber = subSequenceNumber;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Long getApproximateArrivalTimestamp() {
        return this.approximateArrivalTimestamp;
    }

    public Long getSubSequenceNumber() {
        return this.subSequenceNumber;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setApproximateArrivalTimestamp(Long approximateArrivalTimestamp) {
        this.approximateArrivalTimestamp = approximateArrivalTimestamp;
    }

    public void setSubSequenceNumber(Long subSequenceNumber) {
        this.subSequenceNumber = subSequenceNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonFriendlyRecord)) {
            return false;
        }
        JsonFriendlyRecord other = (JsonFriendlyRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$approximateArrivalTimestamp = this.getApproximateArrivalTimestamp();
        Long other$approximateArrivalTimestamp = other.getApproximateArrivalTimestamp();
        if (this$approximateArrivalTimestamp == null ? other$approximateArrivalTimestamp != null : !((Object)this$approximateArrivalTimestamp).equals(other$approximateArrivalTimestamp)) {
            return false;
        }
        Long this$subSequenceNumber = this.getSubSequenceNumber();
        Long other$subSequenceNumber = other.getSubSequenceNumber();
        if (this$subSequenceNumber == null ? other$subSequenceNumber != null : !((Object)this$subSequenceNumber).equals(other$subSequenceNumber)) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        String this$partitionKey = this.getPartitionKey();
        String other$partitionKey = other.getPartitionKey();
        if (this$partitionKey == null ? other$partitionKey != null : !this$partitionKey.equals(other$partitionKey)) {
            return false;
        }
        String this$sequenceNumber = this.getSequenceNumber();
        String other$sequenceNumber = other.getSequenceNumber();
        return !(this$sequenceNumber == null ? other$sequenceNumber != null : !this$sequenceNumber.equals(other$sequenceNumber));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonFriendlyRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $approximateArrivalTimestamp = this.getApproximateArrivalTimestamp();
        result = result * 59 + ($approximateArrivalTimestamp == null ? 43 : ((Object)$approximateArrivalTimestamp).hashCode());
        Long $subSequenceNumber = this.getSubSequenceNumber();
        result = result * 59 + ($subSequenceNumber == null ? 43 : ((Object)$subSequenceNumber).hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        String $partitionKey = this.getPartitionKey();
        result = result * 59 + ($partitionKey == null ? 43 : $partitionKey.hashCode());
        String $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + ($sequenceNumber == null ? 43 : $sequenceNumber.hashCode());
        return result;
    }

    public String toString() {
        return "JsonFriendlyRecord(data=" + Arrays.toString(this.getData()) + ", partitionKey=" + this.getPartitionKey() + ", sequenceNumber=" + this.getSequenceNumber() + ", approximateArrivalTimestamp=" + this.getApproximateArrivalTimestamp() + ", subSequenceNumber=" + this.getSubSequenceNumber() + ")";
    }
}

