/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.arns.Arn;
import software.amazon.kinesis.common.StreamIdentifier;
import software.amazon.kinesis.multilang.config.MultiLangDaemonConfiguration;

public class KinesisClientLibConfigurator {
    private static final Logger log = LoggerFactory.getLogger(KinesisClientLibConfigurator.class);
    private final ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
    private final BeanUtilsBean utilsBean = new BeanUtilsBean(this.convertUtilsBean);
    private final MultiLangDaemonConfiguration configuration = new MultiLangDaemonConfiguration(this.utilsBean, this.convertUtilsBean);

    public MultiLangDaemonConfiguration getConfiguration(Properties properties) {
        properties.entrySet().forEach(e -> {
            try {
                log.info("Processing (key={}, value={})", e.getKey(), e.getValue());
                this.utilsBean.setProperty((Object)this.configuration, this.processKey((String)e.getKey()), e.getValue());
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        });
        Validate.notBlank((CharSequence)this.configuration.getApplicationName(), (String)"Application name is required", (Object[])new Object[0]);
        if (this.configuration.getStreamArn() != null && !this.configuration.getStreamArn().trim().isEmpty()) {
            Arn streamArnObj = Arn.fromString((String)this.configuration.getStreamArn());
            StreamIdentifier.validateArn((Arn)streamArnObj);
            String streamNameFromArn = streamArnObj.resource().resource();
            this.configuration.setStreamName(streamNameFromArn);
        }
        Validate.notBlank((CharSequence)this.configuration.getStreamName(), (String)"Stream name or Stream Arn is required. Stream Arn takes precedence if both are passed in.", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.configuration.getKinesisCredentialsProvider().isDirty(), (String)"A basic set of AWS credentials must be provided", (Object[])new Object[0]);
        return this.configuration;
    }

    public MultiLangDaemonConfiguration getConfiguration(InputStream configStream) {
        Properties properties = new Properties();
        try {
            properties.load(configStream);
        }
        catch (IOException e) {
            String msg = "Could not load properties from the stream provided";
            throw new IllegalStateException(msg, e);
        }
        finally {
            try {
                configStream.close();
            }
            catch (IOException e) {
                String msg = "Encountered error while trying to close properties file.";
                throw new IllegalStateException(msg, e);
            }
        }
        return this.getConfiguration(properties);
    }

    String processKey(String key) {
        if (key.toLowerCase().startsWith("awscredentialsprovider")) {
            key = key.replaceAll("(?i)awscredentialsprovider", "awsCredentialsProvider");
        }
        return key;
    }
}

