/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang.config;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.lang3.StringUtils;
import software.amazon.kinesis.multilang.config.BuilderDynaBean;
import software.amazon.kinesis.multilang.config.DynaBeanBuilderUtils;
import software.amazon.kinesis.multilang.config.TypeTag;

class DynaBeanCreateSupport {
    private final Class<?> destinedClass;
    private final ConvertUtilsBean convertUtilsBean;
    private final List<String> classPrefixSearchList;
    private final List<TypeTag> createTypes = new ArrayList<TypeTag>();
    private Object[] createValues = null;

    DynaBeanCreateSupport(Class<?> destinedClass, ConvertUtilsBean convertUtilsBean, List<String> classPrefixSearchList) {
        this.destinedClass = destinedClass;
        this.convertUtilsBean = convertUtilsBean;
        this.classPrefixSearchList = classPrefixSearchList;
        this.readTypes();
    }

    private void readTypes() {
        for (Method method : this.destinedClass.getMethods()) {
            if (!"create".equals(method.getName()) || !method.getReturnType().isAssignableFrom(this.destinedClass)) continue;
            this.createValues = new Object[method.getParameterCount()];
            int i = 0;
            for (Class<?> paramType : method.getParameterTypes()) {
                if (this.convertUtilsBean.lookup(paramType) != null) {
                    this.createTypes.add(new TypeTag(paramType, true, null));
                } else {
                    this.createTypes.add(new TypeTag(paramType, false, null));
                }
                ++i;
            }
        }
    }

    Object build() {
        Method createMethod = DynaBeanBuilderUtils.getMethod(this.destinedClass, "create", (Class[])this.createTypes.stream().map(t -> t.type).toArray(Class[]::new));
        Object[] arguments = new Object[this.createValues.length];
        for (int i = 0; i < this.createValues.length; ++i) {
            arguments[i] = this.createValues[i] instanceof BuilderDynaBean ? ((BuilderDynaBean)this.createValues[i]).build(this.createTypes.get((int)i).type, new Function[0]) : this.createValues[i];
        }
        return DynaBeanBuilderUtils.invokeOrFail(createMethod, null, arguments);
    }

    public Object get(String name, int index) {
        if (index < this.createValues.length) {
            if (this.createTypes.get((int)index).hasConverter) {
                return this.createValues[index];
            }
            if (this.createValues[index] == null) {
                this.createValues[index] = new BuilderDynaBean(this.createTypes.get((int)index).type, this.convertUtilsBean, null, this.classPrefixSearchList);
            }
            return this.createValues[index];
        }
        return null;
    }

    public void set(String name, int index, Object value) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            if (index >= this.createValues.length) {
                throw new IllegalArgumentException(String.format("%d exceeds the maximum number of arguments (%d) for %s", index, this.createValues.length, this.destinedClass.getName()));
            }
            this.createValues[index] = value;
        }
    }
}

