/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.jsii.JsiiError;
import software.amazon.jsii.JsiiModule;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiPromise;
import software.amazon.jsii.JsiiRuntime;
import software.amazon.jsii.NativeType;
import software.amazon.jsii.Util;
import software.amazon.jsii.api.Callback;
import software.amazon.jsii.api.CreateRequest;
import software.amazon.jsii.api.JsiiOverride;

public final class JsiiClient {
    private static final JsonNodeFactory JSON = JsonNodeFactory.instance;
    private final JsiiRuntime runtime;

    public JsiiClient(JsiiRuntime runtime) {
        this.runtime = runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadModule(JsiiModule module) {
        try {
            Path tarball = Util.extractResource(module.getModuleClass(), module.getBundleResourceName(), null);
            try {
                ObjectNode req = this.makeRequest("load");
                req.put("tarball", tarball.toString());
                req.put("name", module.getModuleName());
                req.put("version", module.getModuleVersion());
                this.runtime.requestResponse((JsonNode)req);
            }
            finally {
                Files.delete(tarball);
                Files.delete(tarball.getParent());
            }
        }
        catch (IOException e) {
            throw new JsiiError("Unable to extract resource " + module.getBundleResourceName(), e);
        }
    }

    public JsiiObjectRef createObject(String fqn, Collection<Object> initializerArgs, Collection<JsiiOverride> overrides, Collection<String> interfaces) {
        CreateRequest request = new CreateRequest();
        request.setFqn(fqn);
        request.setArgs(initializerArgs);
        request.setOverrides(overrides);
        request.setInterfaces(interfaces);
        ObjectNode req = (ObjectNode)JsiiObjectMapper.valueToTree(request);
        req.put("api", "create");
        JsonNode resp = this.runtime.requestResponse((JsonNode)req);
        return JsiiObjectRef.parse(resp);
    }

    public void deleteObject(JsiiObjectRef objRef) {
        ObjectNode req = this.makeRequest("del", objRef);
        this.runtime.requestResponse((JsonNode)req);
    }

    public JsonNode getPropertyValue(JsiiObjectRef objRef, String property) {
        ObjectNode req = this.makeRequest("get", objRef);
        req.put("property", property);
        return this.runtime.requestResponse((JsonNode)req).get("value");
    }

    public void setPropertyValue(JsiiObjectRef objRef, String property, JsonNode value) {
        ObjectNode req = this.makeRequest("set", objRef);
        req.put("property", property);
        req.set("value", value);
        this.runtime.requestResponse((JsonNode)req);
    }

    public JsonNode getStaticPropertyValue(String fqn, String property) {
        ObjectNode req = this.makeRequest("sget");
        req.put("fqn", fqn);
        req.put("property", property);
        return this.runtime.requestResponse((JsonNode)req).get("value");
    }

    public void setStaticPropertyValue(String fqn, String property, JsonNode value) {
        ObjectNode req = this.makeRequest("sset");
        req.put("fqn", fqn);
        req.put("property", property);
        req.set("value", value);
        this.runtime.requestResponse((JsonNode)req);
    }

    public JsonNode callStaticMethod(String fqn, String method, ArrayNode args) {
        ObjectNode req = this.makeRequest("sinvoke");
        req.put("fqn", fqn);
        req.put("method", method);
        req.set("args", (JsonNode)args);
        JsonNode resp = this.runtime.requestResponse((JsonNode)req);
        return resp.get("result");
    }

    public JsonNode callMethod(JsiiObjectRef objRef, String method, ArrayNode args) {
        ObjectNode req = this.makeRequest("invoke", objRef);
        req.put("method", method);
        req.set("args", (JsonNode)args);
        JsonNode resp = this.runtime.requestResponse((JsonNode)req);
        return resp.get("result");
    }

    public JsiiPromise beginAsyncMethod(JsiiObjectRef objRef, String method, ArrayNode args) {
        ObjectNode req = this.makeRequest("begin", objRef);
        req.put("method", method);
        req.set("args", (JsonNode)args);
        JsonNode resp = this.runtime.requestResponse((JsonNode)req);
        return new JsiiPromise(resp.get("promiseid").asText());
    }

    public JsonNode endAsyncMethod(JsiiPromise promise) {
        ObjectNode req = this.makeRequest("end");
        req.put("promiseid", promise.getPromiseId());
        JsonNode resp = this.runtime.requestResponse((JsonNode)req);
        if (resp == null) {
            return null;
        }
        return resp.get("result");
    }

    public List<Callback> pendingCallbacks() {
        ObjectNode req = this.makeRequest("callbacks");
        JsonNode resp = this.runtime.requestResponse((JsonNode)req);
        JsonNode callbacksResp = resp.get("callbacks");
        if (callbacksResp == null || !callbacksResp.isArray()) {
            throw new JsiiError("Expecting a 'callbacks' key with an array in response");
        }
        ArrayNode callbacksArray = (ArrayNode)callbacksResp;
        ArrayList<Callback> result = new ArrayList<Callback>();
        callbacksArray.forEach(node -> result.add(JsiiObjectMapper.treeToValue(node, NativeType.forClass(Callback.class))));
        return result;
    }

    public void completeCallback(Callback callback, String error, JsonNode result) {
        ObjectNode req = this.makeRequest("complete");
        req.put("cbid", callback.getCbid());
        req.put("err", error);
        req.set("result", result);
        this.runtime.requestResponse((JsonNode)req);
    }

    public JsonNode getModuleNames(String moduleName) {
        ObjectNode req = this.makeRequest("naming");
        req.put("assembly", moduleName);
        JsonNode resp = this.runtime.requestResponse((JsonNode)req);
        return resp.get("naming");
    }

    private ObjectNode makeRequest(String api) {
        ObjectNode req = JSON.objectNode();
        req.put("api", api);
        return req;
    }

    private ObjectNode makeRequest(String api, JsiiObjectRef objRef) {
        ObjectNode req = this.makeRequest(api);
        req.set("objref", objRef.toJson());
        return req;
    }
}

