/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiException;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

public final class JsiiObjectMapper {
    public static final ObjectMapper INSTANCE = new JsiiObjectMapper().getObjectMapper();
    private static final String TOKEN_REF = "$jsii.byref";
    private static final String TOKEN_DATE = "$jsii.date";
    private static final String TOKEN_ENUM = "$jsii.enum";
    private static final String TOKEN_MAP = "$jsii.map";
    private final ObjectMapper objectMapper;
    @Nullable
    private final JsiiEngine jsiiEngine;

    public static <T> T treeToValue(JsonNode tree, NativeType<T> valueType) {
        if (tree == null) {
            return null;
        }
        Object result = INSTANCE.convertValue((Object)tree, valueType.getJavaType());
        return valueType.transform(result);
    }

    public static <T extends JsonNode> T valueToTree(Object value) {
        if (value == null) {
            return null;
        }
        return (T)INSTANCE.valueToTree(value);
    }

    private JsiiObjectMapper() {
        this(null);
    }

    JsiiObjectMapper(@Nullable JsiiEngine jsiiEngine) {
        this.jsiiEngine = jsiiEngine;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule module = new SimpleModule("JSII", Version.unknownVersion());
        module.setDeserializerModifier((BeanDeserializerModifier)new JsiiDeserializerModifier());
        module.setSerializers((SimpleSerializers)new JsiiSerializers());
        module.addSerializer(Enum.class, (JsonSerializer)new EnumSerializer());
        module.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer());
        module.addSerializer(JsiiSerializable.class, (JsonSerializer)new JsiiSerializer());
        this.objectMapper.findAndRegisterModules();
        this.objectMapper.registerModule((Module)module);
    }

    ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    private JsiiEngine getEngine() {
        if (this.jsiiEngine != null) {
            return this.jsiiEngine;
        }
        return JsiiEngine.getInstance();
    }

    private static final class JsiiMapSerializer<T>
    extends JsonSerializer<T> {
        private final JsonSerializer<T> delegate;

        JsiiMapSerializer(JsonSerializer<T> delegate) {
            this.delegate = delegate;
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName(JsiiObjectMapper.TOKEN_MAP);
            if (this.delegate != null) {
                this.delegate.serialize(value, gen, serializers);
            } else {
                gen.writeStartObject();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    serializers.defaultSerializeField((String)entry.getKey(), entry.getValue(), gen);
                }
                gen.writeEndObject();
            }
            gen.writeEndObject();
        }
    }

    private static final class JsiiSerializers
    extends SimpleSerializers {
        private JsiiSerializers() {
        }

        public JsonSerializer<?> findMapSerializer(SerializationConfig config, MapType type, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
            JsonSerializer standard = super.findMapSerializer(config, type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer);
            return new JsiiMapSerializer(standard);
        }
    }

    private static final class InstantSerializer
    extends JsonSerializer<Instant> {
        private InstantSerializer() {
        }

        public void serialize(Instant value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField(JsiiObjectMapper.TOKEN_DATE, value.toString());
            gen.writeEndObject();
        }
    }

    private static final class EnumSerializer
    extends JsonSerializer<Enum> {
        private EnumSerializer() {
        }

        public void serialize(Enum value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            Jsii jsii = this.tryGetJsiiAnnotation(value.getClass());
            if (jsii == null) {
                throw new JsiiException("Cannot serialize non-jsii enums");
            }
            gen.writeStartObject();
            gen.writeStringField(JsiiObjectMapper.TOKEN_ENUM, jsii.fqn() + "/" + value.toString());
            gen.writeEndObject();
        }

        private Jsii tryGetJsiiAnnotation(Class<?> type) {
            Jsii[] ann = (Jsii[])type.getDeclaredAnnotationsByType(Jsii.class);
            if (ann.length == 0) {
                return null;
            }
            return ann[0];
        }
    }

    private final class JsiiSerializer
    extends JsonSerializer<JsiiSerializable> {
        private JsiiSerializer() {
        }

        public void serialize(JsiiSerializable o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            for (Class<?> iface : o.getClass().getInterfaces()) {
                Jsii jsii = JsiiEngine.tryGetJsiiAnnotation(iface, true);
                if (jsii == null) continue;
                JsiiObjectMapper.this.getEngine().loadModule(jsii.module());
            }
            jsonGenerator.writeTree(o.$jsii$toJson());
        }
    }

    public final class JsiiDeserializerModifier
    extends BeanDeserializerModifier {
        public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
            return new JsiiDeserializer(deserializer);
        }

        public JsonDeserializer<?> modifyEnumDeserializer(DeserializationConfig config, JavaType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
            return new JsiiDeserializer(deserializer);
        }

        public JsonDeserializer<?> modifyMapDeserializer(DeserializationConfig config, MapType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
            return new JsiiDeserializer(deserializer);
        }

        public JsonDeserializer<?> modifyMapLikeDeserializer(DeserializationConfig config, MapLikeType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
            return new JsiiDeserializer(deserializer);
        }
    }

    private final class JsiiDeserializer
    extends StdDeserializer<Object>
    implements ContextualDeserializer,
    ResolvableDeserializer {
        public static final long serialVersionUID = 1L;
        private final JsonDeserializer<?> standardDeserializer;

        public JsiiDeserializer(JsonDeserializer<?> standardDeserializer) {
            super(Object.class);
            this.standardDeserializer = standardDeserializer;
        }

        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.readValueAsTree();
            if (node.isObject()) {
                if (node.has(JsiiObjectMapper.TOKEN_DATE)) {
                    return Instant.parse(node.get(JsiiObjectMapper.TOKEN_DATE).textValue());
                }
                if (node.has(JsiiObjectMapper.TOKEN_ENUM)) {
                    return JsiiObjectMapper.this.getEngine().findEnumValue(node.get(JsiiObjectMapper.TOKEN_ENUM).textValue());
                }
                if (node.has(JsiiObjectMapper.TOKEN_REF)) {
                    return JsiiObjectMapper.this.getEngine().nativeFromObjRef(JsiiObjectRef.parse(node));
                }
                if (node.has(JsiiObjectMapper.TOKEN_MAP)) {
                    return JsiiObjectMapper.this.getObjectMapper().treeToValue((TreeNode)node.get(JsiiObjectMapper.TOKEN_MAP), Map.class);
                }
            }
            JsonParser nodeParser = node.traverse(p.getCodec());
            nodeParser.nextToken();
            return this.standardDeserializer.deserialize(nodeParser, ctxt);
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            if (this.standardDeserializer instanceof ContextualDeserializer) {
                return new JsiiDeserializer(((ContextualDeserializer)this.standardDeserializer).createContextual(ctxt, property));
            }
            return this;
        }

        public void resolve(DeserializationContext ctxt) throws JsonMappingException {
            if (this.standardDeserializer instanceof ResolvableDeserializer) {
                ((ResolvableDeserializer)this.standardDeserializer).resolve(ctxt);
            }
        }
    }
}

