/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiObject;

public abstract class NativeType<T> {
    protected static final JavaType[] NO_TYPE_PARAMS = new JavaType[0];
    public static final NativeType<Void> VOID = NativeType.forClass(Void.class);
    private final JavaType javaType;

    public static <T> NativeType<T> forClass(Class<T> simpleType) {
        return new SimpleNativeType<T>(simpleType);
    }

    public static <T> NativeType<List<T>> listOf(NativeType<T> elementType) {
        return new ListNativeType<T>(elementType);
    }

    public static <T> NativeType<Map<String, T>> mapOf(NativeType<T> elementType) {
        return new MapNativeType<T>(elementType);
    }

    public static <T> NativeType<T> forType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)type;
            Class rawType = (Class)genericType.getRawType();
            if (List.class.isAssignableFrom(rawType)) {
                return NativeType.listOf(NativeType.forType(genericType.getActualTypeArguments()[0]));
            }
            if (Map.class.isAssignableFrom(rawType)) {
                return NativeType.mapOf(NativeType.forType(genericType.getActualTypeArguments()[1]));
            }
        }
        if (!(type instanceof Class)) {
            throw new IllegalArgumentException(String.format("Unsupported type: %s", type));
        }
        if (List.class.isAssignableFrom((Class)type)) {
            return NativeType.listOf(NativeType.forClass(Object.class));
        }
        if (Map.class.isAssignableFrom((Class)type)) {
            return NativeType.mapOf(NativeType.forClass(Object.class));
        }
        return NativeType.forClass((Class)type);
    }

    private static Class<?> wireFor(Class<?> type) {
        if (JsiiObject.class.isAssignableFrom(type)) {
            return JsiiObject.class;
        }
        return type;
    }

    protected NativeType(JavaType javaType) {
        this.javaType = javaType;
    }

    final JavaType getJavaType() {
        return this.javaType;
    }

    abstract T transform(Object var1);

    private static final class SimpleNativeType<T>
    extends NativeType<T> {
        private final Class<T> type;

        SimpleNativeType(Class<T> simpleType) {
            super(TypeFactory.defaultInstance().constructSimpleType(NativeType.wireFor(simpleType), NO_TYPE_PARAMS));
            this.type = simpleType;
            if (List.class.isAssignableFrom(this.type)) {
                throw new IllegalArgumentException(String.format("Illegal attempt to create a SimpleNativeType with a List type: %s", this.type.getCanonicalName()));
            }
            if (Map.class.isAssignableFrom(this.type)) {
                throw new IllegalArgumentException(String.format("Illegal attempt to create a SimpleNativeType with a Map type: %s", this.type.getCanonicalName()));
            }
        }

        Class<T> getType() {
            return this.type;
        }

        @Override
        T transform(Object value) {
            if (value != null && this.getType().isInterface() && value instanceof JsiiObject && !this.getType().isAssignableFrom(value.getClass()) && this.getType().isAnnotationPresent(Jsii.Proxy.class)) {
                Jsii.Proxy annotation = this.getType().getAnnotation(Jsii.Proxy.class);
                return (T)((JsiiObject)value).asInterfaceProxy(annotation.value());
            }
            return (T)value;
        }
    }

    private static final class ListNativeType<T>
    extends NativeType<List<T>> {
        private final NativeType<T> elementType;

        ListNativeType(NativeType<T> elementType) {
            super((JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, elementType.getJavaType()));
            this.elementType = elementType;
        }

        NativeType<T> getElementType() {
            return this.elementType;
        }

        @Override
        List<T> transform(Object value) {
            List original = (List)value;
            return original.stream().map(this.getElementType()::transform).collect(Collectors.toList());
        }
    }

    private static final class MapNativeType<T>
    extends NativeType<Map<String, T>> {
        private static final JavaType STRING_JAVA_TYPE = TypeFactory.defaultInstance().constructSimpleType(String.class, NO_TYPE_PARAMS);
        private final NativeType<T> elementType;

        MapNativeType(NativeType<T> elementType) {
            super((JavaType)TypeFactory.defaultInstance().constructMapType(Map.class, STRING_JAVA_TYPE, elementType.getJavaType()));
            this.elementType = elementType;
        }

        NativeType<T> getElementType() {
            return this.elementType;
        }

        @Override
        Map<String, T> transform(Object value) {
            Map original = (Map)value;
            return original.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getElementType().transform(entry.getValue()), (existing, replacement) -> existing, LinkedHashMap::new));
        }
    }
}

