/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import javax.annotation.Nullable;
import software.amazon.jsii.JsiiClient;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiException;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiPromise;
import software.amazon.jsii.JsiiSerializable;

public class JsiiObject
implements JsiiSerializable {
    private static final JsiiObjectMapper OM = JsiiObjectMapper.instance;
    private static final JsiiEngine engine = JsiiEngine.getInstance();
    private JsiiObjectRef objRef;

    protected JsiiObject(InitializationMode initializationMode) {
        if (initializationMode != InitializationMode.Jsii) {
            throw new JsiiException("The only supported initialization mode is 'Jsii'");
        }
    }

    @Nullable
    protected final <T> T jsiiCall(String method, Class<T> returnType, Object ... args) {
        try {
            return OM.treeToValue(engine.getClient().callMethod(this.objRef, method, (ArrayNode)OM.valueToTree(args)), returnType);
        }
        catch (JsonProcessingException e) {
            throw new JsiiException(e);
        }
    }

    @Nullable
    protected static <T> T jsiiStaticCall(Class<?> nativeClass, String method, Class<T> returnType, Object ... args) {
        String fqn = engine.loadModuleForClass(nativeClass);
        try {
            return OM.treeToValue(engine.getClient().callStaticMethod(fqn, method, (ArrayNode)OM.valueToTree(args)), returnType);
        }
        catch (JsonProcessingException e) {
            throw new JsiiException(e);
        }
    }

    @Nullable
    protected final <T> T jsiiAsyncCall(String method, Class<T> returnType, Object ... args) {
        try {
            JsiiClient client = engine.getClient();
            JsiiPromise promise = client.beginAsyncMethod(this.objRef, method, (ArrayNode)OM.valueToTree(args));
            engine.processAllPendingCallbacks();
            JsonNode ret = client.endAsyncMethod(promise);
            return OM.treeToValue(ret, returnType);
        }
        catch (JsonProcessingException e) {
            throw new JsiiException(e);
        }
    }

    @Nullable
    protected final <T> T jsiiGet(String property, Class<T> type) {
        try {
            return OM.treeToValue(engine.getClient().getPropertyValue(this.objRef, property), type);
        }
        catch (JsonProcessingException e) {
            throw new JsiiException(e);
        }
    }

    @Nullable
    protected static <T> T jsiiStaticGet(Class<?> nativeClass, String property, Class<T> type) {
        try {
            String fqn = engine.loadModuleForClass(nativeClass);
            return OM.treeToValue(engine.getClient().getStaticPropertyValue(fqn, property), type);
        }
        catch (JsonProcessingException e) {
            throw new JsiiException(e);
        }
    }

    protected final void jsiiSet(String property, @Nullable Object value) {
        engine.getClient().setPropertyValue(this.objRef, property, (JsonNode)OM.valueToTree(value));
    }

    protected static void jsiiStaticSet(Class<?> nativeClass, String property, @Nullable Object value) {
        String fqn = engine.loadModuleForClass(nativeClass);
        engine.getClient().setStaticPropertyValue(fqn, property, (JsonNode)OM.valueToTree(value));
    }

    final void setObjRef(JsiiObjectRef objRef) {
        this.objRef = objRef;
    }

    final JsiiObjectRef getObjRef() {
        return this.objRef;
    }

    public static enum InitializationMode {
        Jsii;

    }
}

