/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiException;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

public final class JsiiObjectMapper {
    private static final String TOKEN_REF = "$jsii.byref";
    private static final String TOKEN_DATE = "$jsii.date";
    private static final String TOKEN_ENUM = "$jsii.enum";
    private static ObjectMapper standardMapper = new ObjectMapper();
    private ObjectMapper serializer = new ObjectMapper();

    public JsiiObjectMapper() {
        this.serializer.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule module = new SimpleModule();
        module.addSerializer(JsiiSerializable.class, (JsonSerializer)new JsiiSerializer());
        module.addSerializer(Instant.class, (JsonSerializer)new DateSerializer());
        module.addSerializer(Enum.class, (JsonSerializer)new EnumSerializer());
        this.serializer.registerModule((Module)module);
    }

    public <T extends JsonNode> T valueToTree(Object value) {
        if (value == null) {
            return null;
        }
        return (T)this.serializer.valueToTree(value);
    }

    public <T> T treeToValue(JsonNode tree, Class<T> type) throws JsonProcessingException {
        if (tree == null) {
            return null;
        }
        if (tree.isArray()) {
            ArrayNode array = (ArrayNode)tree;
            ArrayList<Object> out = new ArrayList<Object>();
            for (JsonNode x : array) {
                out.add(this.treeToValue(x, Object.class));
            }
            return (T)out;
        }
        if (tree.isObject() && tree.has(TOKEN_DATE)) {
            return (T)Instant.parse(tree.get(TOKEN_DATE).textValue());
        }
        if (tree.isObject() && tree.has(TOKEN_REF)) {
            return (T)JsiiEngine.getInstance().nativeFromObjRef(JsiiObjectRef.parse(tree));
        }
        if (tree.isObject() && tree.has(TOKEN_ENUM)) {
            return (T)JsiiEngine.getInstance().findEnumValue(tree.get(TOKEN_ENUM).textValue());
        }
        if (ObjectNode.class.isAssignableFrom(type)) {
            return (T)tree;
        }
        if (tree.isObject()) {
            ObjectNode objectNode = (ObjectNode)tree;
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterable fields = () -> ((ObjectNode)objectNode).fieldNames();
            for (String field : fields) {
                Object value = this.treeToValue(objectNode.get(field), Object.class);
                map.put(field, value);
            }
            return (T)map;
        }
        return (T)standardMapper.treeToValue((TreeNode)tree, type);
    }

    private static class JsiiSerializer
    extends JsonSerializer<JsiiSerializable> {
        private JsiiSerializer() {
        }

        public void serialize(JsiiSerializable o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            JsiiObjectRef objRef = JsiiEngine.getInstance().nativeToObjRef(o);
            jsonGenerator.writeTree((TreeNode)objRef.toJson());
        }
    }

    private static class DateSerializer
    extends JsonSerializer<Instant> {
        private DateSerializer() {
        }

        public void serialize(Instant value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField(JsiiObjectMapper.TOKEN_DATE, value.toString());
            gen.writeEndObject();
        }
    }

    private static class EnumSerializer
    extends JsonSerializer<Enum> {
        private EnumSerializer() {
        }

        public void serialize(Enum value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            Jsii jsii = JsiiEngine.tryGetJsiiAnnotation(value.getClass(), false);
            if (jsii == null) {
                throw new JsiiException("Cannot serialize non-jsii enums");
            }
            gen.writeStartObject();
            gen.writeStringField(JsiiObjectMapper.TOKEN_ENUM, jsii.fqn() + "/" + value.toString());
            gen.writeEndObject();
        }
    }
}

