/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.util.logging.Logger;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.iam.IamTokenUtility;
import software.amazon.jdbc.plugin.iam.LightRdsUtility;
import software.amazon.jdbc.plugin.iam.RegularRdsUtility;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class IamAuthUtils {
    private static final Logger LOGGER = Logger.getLogger(IamAuthUtils.class.getName());
    private static final String TELEMETRY_FETCH_TOKEN = "fetch authentication token";

    public static String getIamHost(String iamHost, HostSpec hostSpec) {
        if (!StringUtils.isNullOrEmpty(iamHost)) {
            return iamHost;
        }
        return hostSpec.getHost();
    }

    public static int getIamPort(int iamDefaultPort, HostSpec hostSpec, int dialectDefaultPort) {
        if (iamDefaultPort > 0) {
            return iamDefaultPort;
        }
        if (hostSpec.isPortSpecified()) {
            return hostSpec.getPort();
        }
        return dialectDefaultPort;
    }

    public static String getCacheKey(String user, String hostname, int port, Region region) {
        return String.format("%s:%s:%d:%s", region, hostname, port, user);
    }

    public static IamTokenUtility getTokenUtility() {
        try {
            Class.forName("software.amazon.awssdk.services.rds.RdsUtilities");
            return new RegularRdsUtility();
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("software.amazon.awssdk.http.SdkHttpFullRequest");
                Class.forName("software.amazon.awssdk.auth.signer.params.Aws4PresignerParams");
                return new LightRdsUtility();
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(Messages.get("AuthenticationToken.javaSdkNotInClasspath"), ex);
            }
        }
    }

    public static String generateAuthenticationToken(IamTokenUtility tokenUtils, PluginService pluginService, String user, String hostname, int port, Region region, AwsCredentialsProvider awsCredentialsProvider) {
        TelemetryFactory telemetryFactory = pluginService.getTelemetryFactory();
        TelemetryContext telemetryContext = telemetryFactory.openTelemetryContext(TELEMETRY_FETCH_TOKEN, TelemetryTraceLevel.NESTED);
        try {
            String string = tokenUtils.generateAuthenticationToken(awsCredentialsProvider, region, hostname, port, user);
            return string;
        }
        catch (Exception e) {
            if (telemetryContext != null) {
                telemetryContext.setSuccess(false);
                telemetryContext.setException(e);
            }
            throw e;
        }
        finally {
            if (telemetryContext != null) {
                telemetryContext.closeContext();
            }
        }
    }
}

