/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.OpenedConnectionTracker;
import software.amazon.jdbc.plugin.failover.FailoverSQLException;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.Utils;

public class AuroraConnectionTrackerPlugin
extends AbstractConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(AuroraConnectionTrackerPlugin.class.getName());
    private static final long TOPOLOGY_CHANGES_EXPECTED_TIME_NANO = TimeUnit.MINUTES.toNanos(3L);
    private final Set<String> subscribedMethods;
    private static final AtomicLong hostListRefreshEndTimeNano = new AtomicLong(0L);
    private final PluginService pluginService;
    private final RdsUtils rdsHelper;
    private final OpenedConnectionTracker tracker;
    private HostSpec currentWriter = null;
    private boolean needUpdateCurrentWriter = false;

    AuroraConnectionTrackerPlugin(PluginService pluginService, Properties props) {
        this(pluginService, props, new RdsUtils(), new OpenedConnectionTracker(pluginService));
    }

    AuroraConnectionTrackerPlugin(PluginService pluginService, Properties props, RdsUtils rdsUtils, OpenedConnectionTracker tracker) {
        this.pluginService = pluginService;
        this.rdsHelper = rdsUtils;
        this.tracker = tracker;
        HashSet<String> methods = new HashSet<String>(this.pluginService.getTargetDriverDialect().getNetworkBoundMethodNames(props));
        methods.add(JdbcMethod.CONNECTION_CLOSE.methodName);
        methods.add(JdbcMethod.CONNECTION_ABORT.methodName);
        methods.add(JdbcMethod.CONNECT.methodName);
        methods.add(JdbcMethod.NOTIFYNODELISTCHANGED.methodName);
        this.subscribedMethods = Collections.unmodifiableSet(methods);
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return this.subscribedMethods;
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        Connection conn = connectFunc.call();
        if (conn != null) {
            RdsUrlType type = this.rdsHelper.identifyRdsType(hostSpec.getHost());
            if (type.isRdsCluster() || type == RdsUrlType.OTHER || type == RdsUrlType.IP_ADDRESS) {
                hostSpec.resetAliases();
                this.pluginService.fillAliases(conn, hostSpec);
            }
            this.tracker.populateOpenedConnectionQueue(hostSpec, conn);
        }
        return conn;
    }

    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        HostSpec currentHostSpec = this.pluginService.getCurrentHostSpec();
        this.rememberWriter();
        try {
            if (!methodName.equals(JdbcMethod.CONNECTION_CLOSE.methodName) && !methodName.equals(JdbcMethod.CONNECTION_ABORT.methodName)) {
                long localHostListRefreshEndTimeNano = hostListRefreshEndTimeNano.get();
                boolean needRefreshHostLists = false;
                if (localHostListRefreshEndTimeNano > 0L) {
                    if (localHostListRefreshEndTimeNano > System.nanoTime()) {
                        needRefreshHostLists = true;
                    } else {
                        hostListRefreshEndTimeNano.compareAndSet(localHostListRefreshEndTimeNano, 0L);
                    }
                }
                if (this.needUpdateCurrentWriter || needRefreshHostLists) {
                    this.checkWriterChanged(needRefreshHostLists);
                }
            }
            T result = jdbcMethodFunc.call();
            if (methodName.equals(JdbcMethod.CONNECTION_CLOSE.methodName) || methodName.equals(JdbcMethod.CONNECTION_ABORT.methodName)) {
                this.tracker.removeConnectionTracking(currentHostSpec, this.pluginService.getCurrentConnection());
            }
            return result;
        }
        catch (Exception e) {
            if (e instanceof FailoverSQLException) {
                hostListRefreshEndTimeNano.set(System.nanoTime() + TOPOLOGY_CHANGES_EXPECTED_TIME_NANO);
                this.checkWriterChanged(true);
            }
            throw e;
        }
    }

    private void checkWriterChanged(boolean needRefreshHostLists) {
        HostSpec hostSpecAfterFailover;
        if (needRefreshHostLists) {
            try {
                this.pluginService.refreshHostList();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if ((hostSpecAfterFailover = Utils.getWriter(this.pluginService.getAllHosts())) == null) {
            return;
        }
        if (this.currentWriter == null) {
            this.currentWriter = hostSpecAfterFailover;
            this.needUpdateCurrentWriter = false;
        } else if (!this.currentWriter.getHostAndPort().equals(hostSpecAfterFailover.getHostAndPort())) {
            this.tracker.invalidateAllConnections(this.currentWriter);
            this.tracker.logOpenedConnections();
            this.currentWriter = hostSpecAfterFailover;
            this.needUpdateCurrentWriter = false;
            hostListRefreshEndTimeNano.set(0L);
        }
    }

    private void rememberWriter() {
        if (this.currentWriter == null || this.needUpdateCurrentWriter) {
            this.currentWriter = Utils.getWriter(this.pluginService.getAllHosts());
            this.needUpdateCurrentWriter = false;
        }
    }

    @Override
    public void notifyNodeListChanged(Map<String, EnumSet<NodeChangeOptions>> changes) {
        for (String node : changes.keySet()) {
            EnumSet<NodeChangeOptions> nodeChanges = changes.get(node);
            if (nodeChanges.contains((Object)NodeChangeOptions.PROMOTED_TO_READER)) {
                this.tracker.invalidateAllConnections(node);
            }
            if (!nodeChanges.contains((Object)NodeChangeOptions.PROMOTED_TO_WRITER)) continue;
            this.needUpdateCurrentWriter = true;
        }
    }
}

