/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSelector;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.Pair;
import software.amazon.jdbc.util.storage.SlidingExpirationCache;

public class LeastConnectionsHostSelector
implements HostSelector {
    public static final String STRATEGY_LEAST_CONNECTIONS = "leastConnections";
    private final SlidingExpirationCache<Pair, AutoCloseable> databasePools;

    public LeastConnectionsHostSelector(SlidingExpirationCache<Pair, AutoCloseable> databasePools) {
        this.databasePools = databasePools;
    }

    @Override
    public HostSpec getHost(@NonNull List<HostSpec> hosts, @NonNull HostRole role, @Nullable Properties props) throws SQLException {
        List eligibleHosts = hosts.stream().filter(hostSpec -> role.equals((Object)hostSpec.getRole()) && hostSpec.getAvailability().equals((Object)HostAvailability.AVAILABLE)).sorted((hostSpec1, hostSpec2) -> this.getNumConnections((HostSpec)hostSpec1, this.databasePools) - this.getNumConnections((HostSpec)hostSpec2, this.databasePools)).collect(Collectors.toList());
        if (eligibleHosts.size() == 0) {
            throw new SQLException(Messages.get("HostSelector.noHostsMatchingRole", new Object[]{role}));
        }
        return (HostSpec)eligibleHosts.get(0);
    }

    private int getNumConnections(HostSpec hostSpec, SlidingExpirationCache<Pair, AutoCloseable> databasePools) {
        int numConnections = 0;
        String url = hostSpec.getUrl();
        for (Map.Entry<Pair, AutoCloseable> entry : databasePools.getEntries().entrySet()) {
            if (!url.equals(entry.getKey().getValue1()) || !(entry.getValue() instanceof HikariDataSource)) continue;
            numConnections += ((HikariDataSource)entry.getValue()).getHikariPoolMXBean().getActiveConnections();
        }
        return numConnections;
    }
}

