/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.monitoring;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import software.amazon.jdbc.util.ExecutorFactory;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.monitoring.Monitor;
import software.amazon.jdbc.util.monitoring.MonitorState;

public abstract class AbstractMonitor
implements Monitor,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(AbstractMonitor.class.getName());
    protected final AtomicBoolean stop = new AtomicBoolean(false);
    protected final ExecutorService monitorExecutor;
    protected final AtomicLong terminationTimeoutSec = new AtomicLong();
    protected final AtomicLong lastActivityTimestampNanos = new AtomicLong();
    protected final AtomicReference<MonitorState> state = new AtomicReference();

    protected AbstractMonitor(long terminationTimeoutSec) {
        this.terminationTimeoutSec.set(terminationTimeoutSec);
        this.monitorExecutor = ExecutorFactory.newSingleThreadExecutor(this.getMonitorNameSuffix());
        this.lastActivityTimestampNanos.set(System.nanoTime());
    }

    protected AbstractMonitor(long terminationTimeoutSec, ExecutorService monitorExecutor) {
        this.terminationTimeoutSec.set(terminationTimeoutSec);
        this.monitorExecutor = monitorExecutor;
        this.lastActivityTimestampNanos.set(System.nanoTime());
    }

    @Override
    public void start() {
        this.monitorExecutor.submit(this);
        this.monitorExecutor.shutdown();
    }

    @Override
    public void run() {
        try {
            LOGGER.finest(Messages.get("AbstractMonitor.startingMonitor", new Object[]{this}));
            this.state.set(MonitorState.RUNNING);
            this.lastActivityTimestampNanos.set(System.nanoTime());
            this.monitor();
        }
        catch (Exception e) {
            LOGGER.fine(Messages.get("AbstractMonitor.unexpectedError", new Object[]{this, e}));
            this.state.set(MonitorState.ERROR);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void stop() {
        LOGGER.fine(Messages.get("AbstractMonitor.stoppingMonitor", new Object[]{this}));
        this.stop.set(true);
        try {
            if (!this.monitorExecutor.awaitTermination(this.terminationTimeoutSec.get(), TimeUnit.SECONDS)) {
                LOGGER.info(Messages.get("AbstractMonitor.monitorTerminationTimeout", new Object[]{this.terminationTimeoutSec, this}));
                this.monitorExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.info(Messages.get("AbstractMonitor.interruptedWhileTerminating", new Object[]{this}));
            Thread.currentThread().interrupt();
            this.monitorExecutor.shutdownNow();
        }
        finally {
            this.close();
            this.state.set(MonitorState.STOPPED);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public long getLastActivityTimestampNanos() {
        return this.lastActivityTimestampNanos.get();
    }

    @Override
    public MonitorState getState() {
        return this.state.get();
    }

    @Override
    public boolean canDispose() {
        return true;
    }

    private String getMonitorNameSuffix() {
        return this.getClass().getSimpleName().replaceAll("[a-z]", "").toLowerCase();
    }
}

