/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import software.amazon.jdbc.plugin.efm.HostMonitor;
import software.amazon.jdbc.util.ExecutorFactory;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;

public class HostMonitorConnectionContext {
    private static final Logger LOGGER = Logger.getLogger(HostMonitorConnectionContext.class.getName());
    private static final Executor ABORT_EXECUTOR = ExecutorFactory.newSingleThreadExecutor("abort");
    private final TelemetryCounter abortedConnectionsCounter;
    private final long failureDetectionIntervalMillis;
    private final long failureDetectionTimeMillis;
    private final long failureDetectionCount;
    private final Connection connectionToAbort;
    private final HostMonitor monitor;
    private volatile boolean activeContext = true;
    private volatile boolean nodeUnhealthy = false;
    private long startMonitorTimeNano;
    private long expectedActiveMonitoringStartTimeNano;
    private long invalidNodeStartTimeNano;
    private long failureCount;
    private final ReentrantLock lock = new ReentrantLock();

    public HostMonitorConnectionContext(HostMonitor monitor, Connection connectionToAbort, long failureDetectionTimeMillis, long failureDetectionIntervalMillis, long failureDetectionCount, TelemetryCounter abortedConnectionsCounter) {
        this.monitor = monitor;
        this.connectionToAbort = connectionToAbort;
        this.failureDetectionTimeMillis = failureDetectionTimeMillis;
        this.failureDetectionIntervalMillis = failureDetectionIntervalMillis;
        this.failureDetectionCount = failureDetectionCount;
        this.abortedConnectionsCounter = abortedConnectionsCounter;
    }

    void setStartMonitorTimeNano(long startMonitorTimeNano) {
        this.startMonitorTimeNano = startMonitorTimeNano;
        this.expectedActiveMonitoringStartTimeNano = startMonitorTimeNano + TimeUnit.MILLISECONDS.toNanos(this.failureDetectionTimeMillis);
    }

    public long getFailureDetectionIntervalMillis() {
        return this.failureDetectionIntervalMillis;
    }

    public long getFailureDetectionCount() {
        return this.failureDetectionCount;
    }

    public long getFailureCount() {
        return this.failureCount;
    }

    public long getExpectedActiveMonitoringStartTimeNano() {
        return this.expectedActiveMonitoringStartTimeNano;
    }

    public HostMonitor getMonitor() {
        return this.monitor;
    }

    void setFailureCount(long failureCount) {
        this.failureCount = failureCount;
    }

    void setInvalidNodeStartTimeNano(long invalidNodeStartTimeNano) {
        this.invalidNodeStartTimeNano = invalidNodeStartTimeNano;
    }

    void resetInvalidNodeStartTime() {
        this.invalidNodeStartTimeNano = 0L;
    }

    boolean isInvalidNodeStartTimeDefined() {
        return this.invalidNodeStartTimeNano > 0L;
    }

    long getInvalidNodeStartTimeNano() {
        return this.invalidNodeStartTimeNano;
    }

    public boolean isNodeUnhealthy() {
        return this.nodeUnhealthy;
    }

    void setNodeUnhealthy(boolean nodeUnhealthy) {
        this.nodeUnhealthy = nodeUnhealthy;
    }

    public boolean isActiveContext() {
        return this.activeContext;
    }

    public void setInactive() {
        this.activeContext = false;
    }

    void abortConnection() {
        if (this.connectionToAbort == null || !this.activeContext) {
            return;
        }
        try {
            this.connectionToAbort.abort(ABORT_EXECUTOR);
            this.connectionToAbort.close();
            if (this.abortedConnectionsCounter != null) {
                this.abortedConnectionsCounter.inc();
            }
        }
        catch (SQLException sqlEx) {
            LOGGER.finest(() -> Messages.get("HostMonitorConnectionContext.exceptionAbortingConnection", new Object[]{sqlEx.getMessage()}));
        }
    }

    public void updateConnectionStatus(String hostName, long statusCheckStartTimeNano, long statusCheckEndTimeNano, boolean isValid) {
        if (!this.activeContext) {
            return;
        }
        long totalElapsedTimeNano = statusCheckEndTimeNano - this.startMonitorTimeNano;
        if (totalElapsedTimeNano > TimeUnit.MILLISECONDS.toNanos(this.failureDetectionTimeMillis)) {
            this.setConnectionValid(hostName, isValid, statusCheckStartTimeNano, statusCheckEndTimeNano);
        }
    }

    void setConnectionValid(String hostName, boolean connectionValid, long statusCheckStartNano, long statusCheckEndNano) {
        if (!connectionValid) {
            long maxInvalidNodeDurationMillis;
            long invalidNodeDurationNano;
            ++this.failureCount;
            if (!this.isInvalidNodeStartTimeDefined()) {
                this.setInvalidNodeStartTimeNano(statusCheckStartNano);
            }
            if ((invalidNodeDurationNano = statusCheckEndNano - this.getInvalidNodeStartTimeNano()) >= TimeUnit.MILLISECONDS.toNanos(maxInvalidNodeDurationMillis = this.getFailureDetectionIntervalMillis() * Math.max(0L, this.getFailureDetectionCount()))) {
                LOGGER.fine(() -> Messages.get("HostMonitorConnectionContext.hostDead", new Object[]{hostName}));
                this.setNodeUnhealthy(true);
                this.abortConnection();
                return;
            }
            LOGGER.finest(() -> Messages.get("HostMonitorConnectionContext.hostNotResponding", new Object[]{hostName, this.getFailureCount()}));
            return;
        }
        this.setFailureCount(0L);
        this.resetInvalidNodeStartTime();
        this.setNodeUnhealthy(false);
        LOGGER.finest(() -> Messages.get("HostMonitorConnectionContext.hostAlive", new Object[]{hostName}));
    }

    public ReentrantLock getLock() {
        return this.lock;
    }
}

