/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.bluegreen;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenPhase;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.Utils;

public class BlueGreenInterimStatus {
    public BlueGreenPhase blueGreenPhase;
    public String version;
    public int port;
    public List<HostSpec> startTopology;
    public List<HostSpec> currentTopology;
    public Map<String, Optional<String>> startIpAddressesByHostMap;
    public Map<String, Optional<String>> currentIpAddressesByHostMap;
    public Set<String> hostNames;
    public boolean allStartTopologyIpChanged;
    public boolean allStartTopologyEndpointsRemoved;
    public boolean allTopologyChanged;

    public BlueGreenInterimStatus(BlueGreenPhase blueGreenPhase, String version, int port, List<HostSpec> startTopology, List<HostSpec> currentTopology, Map<String, Optional<String>> startIpAddressesByHostMap, Map<String, Optional<String>> currentIpAddressesByHostMap, Set<String> hostNames, boolean allStartTopologyIpChanged, boolean allStartTopologyEndpointsRemoved, boolean allTopologyChanged) {
        this.blueGreenPhase = blueGreenPhase;
        this.version = version;
        this.port = port;
        this.startTopology = startTopology;
        this.currentTopology = currentTopology;
        this.startIpAddressesByHostMap = startIpAddressesByHostMap;
        this.currentIpAddressesByHostMap = currentIpAddressesByHostMap;
        this.hostNames = hostNames;
        this.allStartTopologyIpChanged = allStartTopologyIpChanged;
        this.allStartTopologyEndpointsRemoved = allStartTopologyEndpointsRemoved;
        this.allTopologyChanged = allTopologyChanged;
    }

    public String toString() {
        String currentIpMap = this.currentIpAddressesByHostMap.entrySet().stream().map(x -> String.format("%s -> %s", x.getKey(), x.getValue())).collect(Collectors.joining("\n   "));
        String startIpMap = this.startIpAddressesByHostMap.entrySet().stream().map(x -> String.format("%s -> %s", x.getKey(), x.getValue())).collect(Collectors.joining("\n   "));
        String allHostNamesStr = String.join((CharSequence)"\n   ", this.hostNames);
        String startTopologyStr = Utils.logTopology(this.startTopology);
        String currentTopologyStr = Utils.logTopology(this.currentTopology);
        return String.format("%s [\n phase %s, \n version '%s', \n port %d, \n hostNames:\n   %s \n Start %s \n start IP map:\n   %s \n Current %s \n current IP map:\n   %s \n allStartTopologyIpChanged: %s \n allStartTopologyEndpointsRemoved: %s \n allTopologyChanged: %s \n]", super.toString(), this.blueGreenPhase == null ? "<null>" : this.blueGreenPhase, this.version, this.port, StringUtils.isNullOrEmpty(allHostNamesStr) ? "-" : allHostNamesStr, StringUtils.isNullOrEmpty(startTopologyStr) ? "-" : startTopologyStr, StringUtils.isNullOrEmpty(startIpMap) ? "-" : startIpMap, StringUtils.isNullOrEmpty(currentTopologyStr) ? "-" : currentTopologyStr, StringUtils.isNullOrEmpty(currentIpMap) ? "-" : currentIpMap, this.allStartTopologyIpChanged, this.allStartTopologyEndpointsRemoved, this.allTopologyChanged);
    }

    public int getCustomHashCode() {
        int result = this.getValueHash(1, this.blueGreenPhase == null ? "" : this.blueGreenPhase.toString());
        result = this.getValueHash(result, this.version == null ? "" : this.version);
        result = this.getValueHash(result, String.valueOf(this.port));
        result = this.getValueHash(result, String.valueOf(this.allStartTopologyIpChanged));
        result = this.getValueHash(result, String.valueOf(this.allStartTopologyEndpointsRemoved));
        result = this.getValueHash(result, String.valueOf(this.allTopologyChanged));
        result = this.getValueHash(result, this.hostNames == null ? "" : this.hostNames.stream().sorted().collect(Collectors.joining(",")));
        result = this.getValueHash(result, this.startTopology == null ? "" : this.startTopology.stream().map(x -> x.getHostAndPort() + (Object)((Object)x.getRole())).sorted(Comparator.comparing(x -> x)).collect(Collectors.joining(",")));
        result = this.getValueHash(result, this.currentTopology == null ? "" : this.currentTopology.stream().map(x -> x.getHostAndPort() + (Object)((Object)x.getRole())).sorted(Comparator.comparing(x -> x)).collect(Collectors.joining(",")));
        result = this.getValueHash(result, this.startIpAddressesByHostMap == null ? "" : this.startIpAddressesByHostMap.entrySet().stream().map(x -> (String)x.getKey() + x.getValue()).sorted(Comparator.comparing(x -> x)).collect(Collectors.joining(",")));
        result = this.getValueHash(result, this.currentIpAddressesByHostMap == null ? "" : this.currentIpAddressesByHostMap.entrySet().stream().map(x -> (String)x.getKey() + x.getValue()).sorted(Comparator.comparing(x -> x)).collect(Collectors.joining(",")));
        return result;
    }

    protected int getValueHash(int currentHash, String val) {
        return currentHash * 31 + val.hashCode();
    }
}

