/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.util.Collections;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.util.Utils;

public class AllowedAndBlockedHosts {
    private final @Nullable Set<String> allowedHostIds;
    private final @Nullable Set<String> blockedHostIds;

    public AllowedAndBlockedHosts(@Nullable Set<String> allowedHostIds, @Nullable Set<String> blockedHostIds) {
        this.allowedHostIds = Utils.isNullOrEmpty(allowedHostIds) ? null : Collections.unmodifiableSet(allowedHostIds);
        this.blockedHostIds = Utils.isNullOrEmpty(blockedHostIds) ? null : Collections.unmodifiableSet(blockedHostIds);
    }

    public @Nullable Set<String> getAllowedHostIds() {
        return this.allowedHostIds;
    }

    public @Nullable Set<String> getBlockedHostIds() {
        return this.blockedHostIds;
    }
}

