/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.limitless;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.limitless.LimitlessConnectionPlugin;
import software.amazon.jdbc.plugin.limitless.LimitlessQueryHelper;
import software.amazon.jdbc.plugin.limitless.LimitlessRouters;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.Utils;
import software.amazon.jdbc.util.connection.ConnectionService;
import software.amazon.jdbc.util.monitoring.AbstractMonitor;
import software.amazon.jdbc.util.storage.StorageService;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class LimitlessRouterMonitor
extends AbstractMonitor {
    private static final Logger LOGGER = Logger.getLogger(LimitlessRouterMonitor.class.getName());
    protected static final String MONITORING_PROPERTY_PREFIX = "limitless-router-monitor-";
    protected static final long TERMINATION_TIMEOUT_SEC = 5L;
    protected final int intervalMs;
    protected final @NonNull HostSpec hostSpec;
    protected final @NonNull StorageService storageService;
    protected final @NonNull String limitlessRouterCacheKey;
    protected final @NonNull Properties props;
    protected final @NonNull ConnectionService connectionService;
    protected final @NonNull LimitlessQueryHelper queryHelper;
    protected final @NonNull TelemetryFactory telemetryFactory;
    protected Connection monitoringConn = null;

    public LimitlessRouterMonitor(@NonNull PluginService pluginService, @NonNull ConnectionService connectionService, @NonNull TelemetryFactory telemetryFactory, @NonNull HostSpec hostSpec, @NonNull StorageService storageService, @NonNull String limitlessRouterCacheKey, @NonNull Properties props, int intervalMs) {
        super(5L);
        this.connectionService = connectionService;
        this.storageService = storageService;
        this.telemetryFactory = telemetryFactory;
        this.hostSpec = hostSpec;
        this.limitlessRouterCacheKey = limitlessRouterCacheKey;
        this.props = PropertyUtils.copyProperties(props);
        props.stringPropertyNames().stream().filter(p -> p.startsWith(MONITORING_PROPERTY_PREFIX)).forEach(p -> {
            this.props.put(p.substring(MONITORING_PROPERTY_PREFIX.length()), this.props.getProperty((String)p));
            this.props.remove(p);
        });
        this.props.setProperty(LimitlessConnectionPlugin.WAIT_FOR_ROUTER_INFO.name, "false");
        this.intervalMs = intervalMs;
        this.queryHelper = new LimitlessQueryHelper(pluginService);
    }

    @Override
    public void close() {
        try {
            if (this.monitoringConn != null && !this.monitoringConn.isClosed()) {
                this.monitoringConn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.monitoringConn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void monitor() {
        LOGGER.finest(() -> Messages.get("LimitlessRouterMonitor.running", new Object[]{this.hostSpec.getHost()}));
        try {
            while (!this.stop.get()) {
                TelemetryContext telemetryContext = this.telemetryFactory.openTelemetryContext("limitless router monitor thread", TelemetryTraceLevel.TOP_LEVEL);
                if (telemetryContext != null) {
                    telemetryContext.setAttribute("url", this.hostSpec.getUrl());
                }
                try {
                    this.openConnection();
                    if (this.monitoringConn == null || this.monitoringConn.isClosed()) continue;
                    List<HostSpec> newLimitlessRouters = this.queryHelper.queryForLimitlessRouters(this.monitoringConn, this.hostSpec.getPort());
                    this.storageService.set(this.limitlessRouterCacheKey, new LimitlessRouters(newLimitlessRouters));
                    LOGGER.finest(Utils.logTopology(newLimitlessRouters, "[limitlessRouterMonitor] Topology:"));
                    TimeUnit.MILLISECONDS.sleep(this.intervalMs);
                }
                catch (Exception ex) {
                    if (telemetryContext == null) throw ex;
                    telemetryContext.setException(ex);
                    telemetryContext.setSuccess(false);
                    throw ex;
                }
                finally {
                    if (telemetryContext == null) continue;
                    telemetryContext.closeContext();
                }
            }
            return;
        }
        catch (InterruptedException exception) {
            LOGGER.finest(() -> Messages.get("LimitlessRouterMonitor.interruptedExceptionDuringMonitoring", new Object[]{this.hostSpec.getHost()}));
            return;
        }
        catch (Exception ex) {
            if (!LOGGER.isLoggable(Level.FINEST)) return;
            LOGGER.log(Level.FINEST, Messages.get("LimitlessRouterMonitor.exceptionDuringMonitoringStop", new Object[]{this.hostSpec.getHost()}), ex);
            return;
        }
        finally {
            this.stop.set(true);
            try {
                if (this.monitoringConn != null && !this.monitoringConn.isClosed()) {
                    this.monitoringConn.close();
                }
            }
            catch (SQLException exception) {}
            this.monitoringConn = null;
        }
    }

    private void openConnection() throws SQLException {
        try {
            if (this.monitoringConn == null || this.monitoringConn.isClosed()) {
                LOGGER.finest(() -> Messages.get("LimitlessRouterMonitor.openingConnection", new Object[]{this.hostSpec.getUrl()}));
                this.monitoringConn = this.connectionService.open(this.hostSpec, this.props);
                LOGGER.finest(() -> Messages.get("LimitlessRouterMonitor.openedConnection", new Object[]{this.monitoringConn}));
            }
        }
        catch (SQLException ex) {
            if (this.monitoringConn != null && !this.monitoringConn.isClosed()) {
                try {
                    this.monitoringConn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.monitoringConn = null;
            }
            throw ex;
        }
    }
}

