/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.wrapper;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.util.WrapperUtils;

public class ParameterMetaDataWrapper
implements ParameterMetaData {
    protected ParameterMetaData parameterMetaData;
    protected ConnectionPluginManager pluginManager;

    public ParameterMetaDataWrapper(@NonNull ParameterMetaData parameterMetaData, @NonNull ConnectionPluginManager pluginManager) {
        this.parameterMetaData = parameterMetaData;
        this.pluginManager = pluginManager;
    }

    @Override
    public int getParameterCount() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.PARAMETERMETADATA_GETPARAMETERCOUNT)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.parameterMetaData, JdbcMethod.PARAMETERMETADATA_GETPARAMETERCOUNT, () -> this.parameterMetaData.getParameterCount(), new Object[0]);
        }
        return this.parameterMetaData.getParameterCount();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.PARAMETERMETADATA_ISNULLABLE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.parameterMetaData, JdbcMethod.PARAMETERMETADATA_ISNULLABLE, () -> this.parameterMetaData.isNullable(param), param);
        }
        return this.parameterMetaData.isNullable(param);
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.PARAMETERMETADATA_ISSIGNED)) {
            return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.parameterMetaData, JdbcMethod.PARAMETERMETADATA_ISSIGNED, () -> this.parameterMetaData.isSigned(param), param);
        }
        return this.parameterMetaData.isSigned(param);
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.PARAMETERMETADATA_GETPRECISION)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.parameterMetaData, JdbcMethod.PARAMETERMETADATA_GETPRECISION, () -> this.parameterMetaData.getPrecision(param), param);
        }
        return this.parameterMetaData.getPrecision(param);
    }

    @Override
    public int getScale(int param) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.PARAMETERMETADATA_GETSCALE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.parameterMetaData, JdbcMethod.PARAMETERMETADATA_GETSCALE, () -> this.parameterMetaData.getScale(param), param);
        }
        return this.parameterMetaData.getScale(param);
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.PARAMETERMETADATA_GETPARAMETERTYPE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.parameterMetaData, JdbcMethod.PARAMETERMETADATA_GETPARAMETERTYPE, () -> this.parameterMetaData.getParameterType(param), param);
        }
        return this.parameterMetaData.getParameterType(param);
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.PARAMETERMETADATA_GETPARAMETERTYPENAME)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.parameterMetaData, JdbcMethod.PARAMETERMETADATA_GETPARAMETERTYPENAME, () -> this.parameterMetaData.getParameterTypeName(param), param);
        }
        return this.parameterMetaData.getParameterTypeName(param);
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.PARAMETERMETADATA_GETPARAMETERCLASSNAME)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.parameterMetaData, JdbcMethod.PARAMETERMETADATA_GETPARAMETERCLASSNAME, () -> this.parameterMetaData.getParameterClassName(param), param);
        }
        return this.parameterMetaData.getParameterClassName(param);
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.PARAMETERMETADATA_GETPARAMETERMODE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.parameterMetaData, JdbcMethod.PARAMETERMETADATA_GETPARAMETERMODE, () -> this.parameterMetaData.getParameterMode(param), param);
        }
        return this.parameterMetaData.getParameterMode(param);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.parameterMetaData.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.parameterMetaData.isWrapperFor(iface);
    }

    public String toString() {
        return super.toString() + " - " + this.parameterMetaData;
    }
}

