/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.efm2.HostMonitor;
import software.amazon.jdbc.plugin.efm2.HostMonitorConnectionContext;
import software.amazon.jdbc.plugin.efm2.HostMonitorImpl;
import software.amazon.jdbc.plugin.efm2.HostMonitorInitializer;
import software.amazon.jdbc.plugin.efm2.HostMonitorService;
import software.amazon.jdbc.util.ExecutorFactory;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.storage.SlidingExpirationCacheWithCleanupThread;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;

public class HostMonitorServiceImpl
implements HostMonitorService {
    private static final Logger LOGGER = Logger.getLogger(HostMonitorServiceImpl.class.getName());
    public static final AwsWrapperProperty MONITOR_DISPOSAL_TIME_MS = new AwsWrapperProperty("monitorDisposalTime", "600000", "Interval in milliseconds for a monitor to be considered inactive and to be disposed.");
    protected static final long CACHE_CLEANUP_NANO = TimeUnit.MINUTES.toNanos(1L);
    protected static final Executor ABORT_EXECUTOR = ExecutorFactory.newSingleThreadExecutor("abort");
    protected static final SlidingExpirationCacheWithCleanupThread<String, HostMonitor> monitors = new SlidingExpirationCacheWithCleanupThread(HostMonitor::canDispose, monitor -> {
        try {
            monitor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }, CACHE_CLEANUP_NANO);
    protected final PluginService pluginService;
    protected final HostMonitorInitializer monitorInitializer;
    protected final TelemetryFactory telemetryFactory;
    protected final TelemetryCounter abortedConnectionsCounter;

    public HostMonitorServiceImpl(@NonNull PluginService pluginService) {
        this(pluginService, (hostSpec, properties, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount, abortedConnectionsCounter) -> new HostMonitorImpl(pluginService, hostSpec, properties, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount, abortedConnectionsCounter));
    }

    HostMonitorServiceImpl(@NonNull PluginService pluginService, @NonNull HostMonitorInitializer monitorInitializer) {
        this.pluginService = pluginService;
        this.telemetryFactory = pluginService.getTelemetryFactory();
        this.abortedConnectionsCounter = this.telemetryFactory.createCounter("efm2.connections.aborted");
        this.monitorInitializer = monitorInitializer;
    }

    public static void closeAllMonitors() {
        monitors.getEntries().values().forEach(monitor -> {
            try {
                monitor.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        monitors.clear();
    }

    @Override
    public HostMonitorConnectionContext startMonitoring(Connection connectionToAbort, HostSpec hostSpec, Properties properties, int failureDetectionTimeMillis, int failureDetectionIntervalMillis, int failureDetectionCount) {
        HostMonitor monitor = this.getMonitor(hostSpec, properties, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount);
        HostMonitorConnectionContext context = new HostMonitorConnectionContext(connectionToAbort);
        monitor.startMonitoring(context);
        return context;
    }

    @Override
    public void stopMonitoring(@NonNull HostMonitorConnectionContext context, @NonNull Connection connectionToAbort) {
        if (context.shouldAbort()) {
            context.setInactive();
            try {
                connectionToAbort.abort(ABORT_EXECUTOR);
                connectionToAbort.close();
                if (this.abortedConnectionsCounter != null) {
                    this.abortedConnectionsCounter.inc();
                }
            }
            catch (SQLException sqlEx) {
                LOGGER.finest(() -> Messages.get("HostMonitorConnectionContext.exceptionAbortingConnection", new Object[]{sqlEx.getMessage()}));
            }
        } else {
            context.setInactive();
        }
    }

    @Override
    public void releaseResources() {
    }

    protected HostMonitor getMonitor(HostSpec hostSpec, Properties properties, int failureDetectionTimeMillis, int failureDetectionIntervalMillis, int failureDetectionCount) {
        String monitorKey = String.format("%d:%d:%d:%s", failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount, hostSpec.getUrl());
        long cacheExpirationNano = TimeUnit.MILLISECONDS.toNanos(MONITOR_DISPOSAL_TIME_MS.getLong(properties));
        return monitors.computeIfAbsent(monitorKey, key -> this.monitorInitializer.createMonitor(hostSpec, properties, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount, this.abortedConnectionsCounter), cacheExpirationNano);
    }
}

