/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.ConnectionPluginChainBuilder;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.OldConnectionSuggestedAction;
import software.amazon.jdbc.PluginManagerService;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.cleanup.CanReleaseResources;
import software.amazon.jdbc.plugin.AuroraConnectionTrackerPlugin;
import software.amazon.jdbc.plugin.AuroraInitialConnectionStrategyPlugin;
import software.amazon.jdbc.plugin.AwsSecretsManagerConnectionPlugin;
import software.amazon.jdbc.plugin.DataCacheConnectionPlugin;
import software.amazon.jdbc.plugin.DefaultConnectionPlugin;
import software.amazon.jdbc.plugin.ExecutionTimeConnectionPlugin;
import software.amazon.jdbc.plugin.LogQueryConnectionPlugin;
import software.amazon.jdbc.plugin.customendpoint.CustomEndpointPlugin;
import software.amazon.jdbc.plugin.efm.HostMonitoringConnectionPlugin;
import software.amazon.jdbc.plugin.failover.FailoverConnectionPlugin;
import software.amazon.jdbc.plugin.federatedauth.FederatedAuthPlugin;
import software.amazon.jdbc.plugin.federatedauth.OktaAuthPlugin;
import software.amazon.jdbc.plugin.iam.IamAuthConnectionPlugin;
import software.amazon.jdbc.plugin.limitless.LimitlessConnectionPlugin;
import software.amazon.jdbc.plugin.readwritesplitting.ReadWriteSplittingPlugin;
import software.amazon.jdbc.plugin.staledns.AuroraStaleDnsPlugin;
import software.amazon.jdbc.plugin.strategy.fastestresponse.FastestResponseStrategyPlugin;
import software.amazon.jdbc.profile.ConfigurationProfile;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.Utils;
import software.amazon.jdbc.util.WrapperUtils;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;
import software.amazon.jdbc.wrapper.ConnectionWrapper;

public class ConnectionPluginManager
implements CanReleaseResources,
Wrapper {
    private static final Logger LOGGER = Logger.getLogger(ConnectionPluginManager.class.getName());
    protected static final Map<Class<? extends ConnectionPlugin>, String> pluginNameByClass = new HashMap<Class<? extends ConnectionPlugin>, String>(){
        {
            this.put(LimitlessConnectionPlugin.class, "plugin:limitless");
            this.put(ExecutionTimeConnectionPlugin.class, "plugin:executionTime");
            this.put(AuroraConnectionTrackerPlugin.class, "plugin:auroraConnectionTracker");
            this.put(LogQueryConnectionPlugin.class, "plugin:logQuery");
            this.put(DataCacheConnectionPlugin.class, "plugin:dataCache");
            this.put(HostMonitoringConnectionPlugin.class, "plugin:efm");
            this.put(software.amazon.jdbc.plugin.efm2.HostMonitoringConnectionPlugin.class, "plugin:efm2");
            this.put(FailoverConnectionPlugin.class, "plugin:failover");
            this.put(software.amazon.jdbc.plugin.failover2.FailoverConnectionPlugin.class, "plugin:failover2");
            this.put(IamAuthConnectionPlugin.class, "plugin:iam");
            this.put(AwsSecretsManagerConnectionPlugin.class, "plugin:awsSecretsManager");
            this.put(FederatedAuthPlugin.class, "plugin:federatedAuth");
            this.put(OktaAuthPlugin.class, "plugin:okta");
            this.put(AuroraStaleDnsPlugin.class, "plugin:auroraStaleDns");
            this.put(ReadWriteSplittingPlugin.class, "plugin:readWriteSplitting");
            this.put(FastestResponseStrategyPlugin.class, "plugin:fastestResponseStrategy");
            this.put(DefaultConnectionPlugin.class, "plugin:targetDriver");
            this.put(AuroraInitialConnectionStrategyPlugin.class, "plugin:initialConnection");
            this.put(CustomEndpointPlugin.class, "plugin:customEndpoint");
        }
    };
    private final ReentrantLock lock = new ReentrantLock();
    protected Properties props = new Properties();
    protected List<ConnectionPlugin> plugins;
    protected final @NonNull ConnectionProvider defaultConnProvider;
    protected final @Nullable ConnectionProvider effectiveConnProvider;
    protected final ConnectionWrapper connectionWrapper;
    protected FullServicesContainer servicesContainer;
    protected PluginService pluginService;
    protected TelemetryFactory telemetryFactory;
    protected boolean isTelemetryInUse;
    protected final PluginChainJdbcCallableInfo[] pluginChainFuncMap;

    public ConnectionPluginManager(@NonNull ConnectionProvider defaultConnProvider, @Nullable ConnectionProvider effectiveConnProvider, @Nullable ConnectionWrapper connectionWrapper, @NonNull TelemetryFactory telemetryFactory) {
        this.pluginChainFuncMap = new PluginChainJdbcCallableInfo[JdbcMethod.ALL.id + 1];
        this.defaultConnProvider = defaultConnProvider;
        this.effectiveConnProvider = effectiveConnProvider;
        this.connectionWrapper = connectionWrapper;
        this.telemetryFactory = telemetryFactory;
        this.isTelemetryInUse = telemetryFactory.inUse();
    }

    ConnectionPluginManager(@NonNull ConnectionProvider defaultConnProvider, @Nullable ConnectionProvider effectiveConnProvider, Properties props, List<ConnectionPlugin> plugins, ConnectionWrapper connectionWrapper, PluginService pluginService, TelemetryFactory telemetryFactory) {
        this(defaultConnProvider, effectiveConnProvider, props, plugins, connectionWrapper, telemetryFactory);
        this.pluginService = pluginService;
    }

    ConnectionPluginManager(@NonNull ConnectionProvider defaultConnProvider, @Nullable ConnectionProvider effectiveConnProvider, Properties props, List<ConnectionPlugin> plugins, ConnectionWrapper connectionWrapper, TelemetryFactory telemetryFactory) {
        this.pluginChainFuncMap = new PluginChainJdbcCallableInfo[JdbcMethod.ALL.id + 1];
        this.defaultConnProvider = defaultConnProvider;
        this.effectiveConnProvider = effectiveConnProvider;
        this.props = props;
        this.plugins = plugins;
        this.connectionWrapper = connectionWrapper;
        this.telemetryFactory = telemetryFactory;
        this.isTelemetryInUse = telemetryFactory.inUse();
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void init(FullServicesContainer servicesContainer, Properties props, PluginManagerService pluginManagerService, @Nullable ConfigurationProfile configurationProfile) throws SQLException {
        this.props = props;
        this.servicesContainer = servicesContainer;
        this.pluginService = servicesContainer.getPluginService();
        this.telemetryFactory = servicesContainer.getTelemetryFactory();
        this.isTelemetryInUse = this.telemetryFactory.inUse();
        ConnectionPluginChainBuilder pluginChainBuilder = new ConnectionPluginChainBuilder();
        this.plugins = pluginChainBuilder.getPlugins(this.servicesContainer, this.defaultConnProvider, this.effectiveConnProvider, pluginManagerService, props, configurationProfile);
    }

    protected <T, E extends Exception> T executeWithSubscribedPlugins(JdbcMethod jdbcMethod, PluginPipeline<T, E> pluginPipeline, JdbcCallable<T, E> jdbcMethodFunc, @Nullable ConnectionPlugin pluginToSkip) throws E {
        if (pluginPipeline == null) {
            throw new IllegalArgumentException("pluginPipeline");
        }
        if (jdbcMethodFunc == null) {
            throw new IllegalArgumentException("jdbcMethodFunc");
        }
        PluginChainJdbcCallableInfo<T, E> pluginChainJdbcCallableInfo = this.pluginChainFuncMap[jdbcMethod.id];
        if (pluginChainJdbcCallableInfo == null) {
            pluginChainJdbcCallableInfo = this.makePluginChainFunc(jdbcMethod.methodName);
            if (pluginChainJdbcCallableInfo == null || ((PluginChainJdbcCallableInfo)pluginChainJdbcCallableInfo).func == null) {
                throw new RuntimeException("Error processing this JDBC call.");
            }
            this.pluginChainFuncMap[jdbcMethod.id] = pluginChainJdbcCallableInfo;
        }
        if (pluginChainJdbcCallableInfo == null) {
            throw new RuntimeException("Error processing this JDBC call.");
        }
        if (jdbcMethod.alwaysUsePipeline || pluginChainJdbcCallableInfo.isSubscribed) {
            PluginChainJdbcCallable pluginChainFunc = ((PluginChainJdbcCallableInfo)pluginChainJdbcCallableInfo).func;
            return pluginChainFunc.call(pluginPipeline, jdbcMethodFunc, pluginToSkip);
        }
        return jdbcMethodFunc.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, E extends Exception> T executeWithTelemetry(@NonNull JdbcCallable<T, E> execution, @NonNull String pluginName) throws E {
        TelemetryContext context = this.telemetryFactory.openTelemetryContext(pluginName, TelemetryTraceLevel.NESTED);
        try {
            T t = execution.call();
            return t;
        }
        finally {
            if (context != null) {
                context.closeContext();
            }
        }
    }

    protected <T, E extends Exception> @Nullable PluginChainJdbcCallableInfo<T, E> makePluginChainFunc(@NonNull String methodName) {
        PluginChainJdbcCallable pluginChainFunc = null;
        boolean isSubscribed = false;
        for (int i = this.plugins.size() - 1; i >= 0; --i) {
            ConnectionPlugin plugin = this.plugins.get(i);
            Set<String> pluginSubscribedMethods = plugin.getSubscribedMethods();
            String pluginName = pluginNameByClass.getOrDefault(plugin.getClass(), plugin.getClass().getSimpleName());
            boolean isPluginSubscribed = pluginSubscribedMethods.contains(JdbcMethod.ALL.methodName) || pluginSubscribedMethods.contains(methodName);
            isSubscribed |= isPluginSubscribed && !(plugin instanceof DefaultConnectionPlugin);
            if (!isPluginSubscribed) continue;
            if (pluginChainFunc == null) {
                pluginChainFunc = (pipelineFunc, jdbcFunc, pluginToSkip) -> this.executeWithTelemetry(() -> pipelineFunc.call(plugin, jdbcFunc), pluginName);
                continue;
            }
            PluginChainJdbcCallable finalPluginChainFunc = pluginChainFunc;
            pluginChainFunc = (pipelineFunc, jdbcFunc, pluginToSkip) -> {
                if (pluginToSkip == plugin) {
                    return finalPluginChainFunc.call(pipelineFunc, jdbcFunc, pluginToSkip);
                }
                return this.executeWithTelemetry(() -> pipelineFunc.call(plugin, () -> finalPluginChainFunc.call(pipelineFunc, jdbcFunc, pluginToSkip)), pluginName);
            };
        }
        return new PluginChainJdbcCallableInfo(pluginChainFunc, isSubscribed);
    }

    protected <E extends Exception> void notifySubscribedPlugins(String methodName, PluginPipeline<Void, E> pluginPipeline, ConnectionPlugin skipNotificationForThisPlugin) throws E {
        if (pluginPipeline == null) {
            throw new IllegalArgumentException("pluginPipeline");
        }
        for (ConnectionPlugin plugin : this.plugins) {
            Set<String> pluginSubscribedMethods;
            boolean isSubscribed;
            if (plugin == skipNotificationForThisPlugin || !(isSubscribed = (pluginSubscribedMethods = plugin.getSubscribedMethods()).contains(JdbcMethod.ALL.methodName) || pluginSubscribedMethods.contains(methodName))) continue;
            pluginPipeline.call(plugin, null);
        }
    }

    public ConnectionWrapper getConnectionWrapper() {
        return this.connectionWrapper;
    }

    public TelemetryFactory getTelemetryFactory() {
        return this.telemetryFactory;
    }

    public boolean mustUsePipeline(JdbcMethod jdbcMethod) {
        PluginChainJdbcCallableInfo pluginChainJdbcCallableInfo = this.pluginChainFuncMap[jdbcMethod.id];
        return jdbcMethod.alwaysUsePipeline || pluginChainJdbcCallableInfo == null || pluginChainJdbcCallableInfo.isSubscribed || this.isTelemetryInUse;
    }

    public <T, E extends Exception> T execute(Class<T> resultType, Class<E> exceptionClass, Object methodInvokeOn, JdbcMethod jdbcMethod, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        Connection conn;
        if (jdbcMethod.shouldLockConnection && jdbcMethod.checkBoundedConnection && (conn = WrapperUtils.getConnectionFromSqlObject(methodInvokeOn)) != null && conn != this.pluginService.getCurrentConnection()) {
            throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, new SQLException(Messages.get("ConnectionPluginManager.invokedAgainstOldConnection", new Object[]{methodInvokeOn})));
        }
        return (T)this.executeWithSubscribedPlugins(jdbcMethod, (plugin, func) -> plugin.execute(resultType, exceptionClass, methodInvokeOn, jdbcMethod.methodName, func, jdbcMethodArgs), jdbcMethodFunc, null);
    }

    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, @Nullable ConnectionPlugin pluginToSkip) throws SQLException {
        TelemetryContext context = this.telemetryFactory.openTelemetryContext("connect", TelemetryTraceLevel.NESTED);
        try {
            Connection connection = this.executeWithSubscribedPlugins(JdbcMethod.CONNECT, (plugin, func) -> plugin.connect(driverProtocol, hostSpec, props, isInitialConnection, func), () -> {
                throw new SQLException("Shouldn't be called.");
            }, pluginToSkip);
            return connection;
        }
        catch (RuntimeException | SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        finally {
            if (context != null) {
                context.closeContext();
            }
        }
    }

    public Connection forceConnect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, @Nullable ConnectionPlugin pluginToSkip) throws SQLException {
        try {
            return this.executeWithSubscribedPlugins(JdbcMethod.FORCECONNECT, (plugin, func) -> plugin.forceConnect(driverProtocol, hostSpec, props, isInitialConnection, func), () -> {
                throw new SQLException("Shouldn't be called.");
            }, pluginToSkip);
        }
        catch (RuntimeException | SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public boolean acceptsStrategy(HostRole role, String strategy) throws SQLException {
        try {
            for (ConnectionPlugin plugin : this.plugins) {
                Set<String> pluginSubscribedMethods = plugin.getSubscribedMethods();
                boolean isSubscribed = pluginSubscribedMethods.contains(JdbcMethod.ALL.methodName) || pluginSubscribedMethods.contains(JdbcMethod.ACCEPTSSTRATEGY.methodName);
                if (!isSubscribed || !plugin.acceptsStrategy(role, strategy)) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public HostSpec getHostSpecByStrategy(HostRole role, String strategy) throws SQLException, UnsupportedOperationException {
        return this.getHostSpecByStrategy(null, role, strategy);
    }

    public HostSpec getHostSpecByStrategy(List<HostSpec> hosts, HostRole role, String strategy) throws SQLException, UnsupportedOperationException {
        try {
            for (ConnectionPlugin plugin : this.plugins) {
                Set<String> pluginSubscribedMethods = plugin.getSubscribedMethods();
                boolean isSubscribed = pluginSubscribedMethods.contains(JdbcMethod.ALL.methodName) || pluginSubscribedMethods.contains(JdbcMethod.GETHOSTSPECBYSTRATEGY.methodName);
                if (!isSubscribed) continue;
                try {
                    HostSpec host = Utils.isNullOrEmpty(hosts) ? plugin.getHostSpecByStrategy(role, strategy) : plugin.getHostSpecByStrategy(hosts, role, strategy);
                    if (host == null) continue;
                    return host;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
            }
            throw new UnsupportedOperationException("The driver does not support the requested host selection strategy: " + strategy);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initHostProvider(String driverProtocol, String initialUrl, Properties props, HostListProviderService hostListProviderService) throws SQLException {
        TelemetryContext context = this.telemetryFactory.openTelemetryContext("initHostProvider", TelemetryTraceLevel.NESTED);
        try {
            this.executeWithSubscribedPlugins(JdbcMethod.INITHOSTPROVIDER, (plugin, func) -> {
                plugin.initHostProvider(driverProtocol, initialUrl, props, hostListProviderService, func);
                return null;
            }, () -> {
                throw new SQLException("Shouldn't be called.");
            }, null);
        }
        finally {
            if (context != null) {
                context.closeContext();
            }
        }
    }

    public EnumSet<OldConnectionSuggestedAction> notifyConnectionChanged(@NonNull EnumSet<NodeChangeOptions> changes, @Nullable ConnectionPlugin skipNotificationForThisPlugin) {
        EnumSet<OldConnectionSuggestedAction> result = EnumSet.noneOf(OldConnectionSuggestedAction.class);
        this.notifySubscribedPlugins(JdbcMethod.NOTIFYCONNECTIONCHANGED.methodName, (plugin, func) -> {
            OldConnectionSuggestedAction pluginOpinion = plugin.notifyConnectionChanged(changes);
            result.add(pluginOpinion);
            return null;
        }, skipNotificationForThisPlugin);
        return result;
    }

    public void notifyNodeListChanged(@NonNull Map<String, EnumSet<NodeChangeOptions>> changes) {
        this.notifySubscribedPlugins(JdbcMethod.NOTIFYNODELISTCHANGED.methodName, (plugin, func) -> {
            plugin.notifyNodeListChanged(changes);
            return null;
        }, null);
    }

    @Override
    public void releaseResources() {
        LOGGER.finest(() -> Messages.get("ConnectionPluginManager.releaseResources"));
        this.plugins.forEach(plugin -> {
            if (plugin instanceof CanReleaseResources) {
                ((CanReleaseResources)((Object)plugin)).releaseResources();
            }
        });
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == ConnectionPluginManager.class) {
            return iface.cast(this);
        }
        if (iface == PluginService.class) {
            return iface.cast(this.pluginService);
        }
        if (this.plugins == null) {
            return null;
        }
        for (ConnectionPlugin p : this.plugins) {
            if (!iface.isAssignableFrom(p.getClass())) continue;
            return iface.cast(p);
        }
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (this.plugins == null) {
            return false;
        }
        for (ConnectionPlugin p : this.plugins) {
            if (!iface.isAssignableFrom(p.getClass())) continue;
            return true;
        }
        return false;
    }

    public @NonNull ConnectionProvider getDefaultConnProvider() {
        return this.defaultConnProvider;
    }

    public @Nullable ConnectionProvider getEffectiveConnProvider() {
        return this.effectiveConnProvider;
    }

    protected static class PluginChainJdbcCallableInfo<T, E extends Exception> {
        private final PluginChainJdbcCallable<T, E> func;
        public final boolean isSubscribed;

        public PluginChainJdbcCallableInfo(PluginChainJdbcCallable<T, E> func, boolean isSubscribed) {
            this.func = func;
            this.isSubscribed = isSubscribed;
        }
    }

    protected static interface PluginChainJdbcCallable<T, E extends Exception> {
        public T call(@NonNull PluginPipeline<T, E> var1, @NonNull JdbcCallable<T, E> var2, @Nullable ConnectionPlugin var3) throws E;
    }

    protected static interface PluginPipeline<T, E extends Exception> {
        public T call(@NonNull ConnectionPlugin var1, @Nullable JdbcCallable<T, E> var2) throws E;
    }
}

