/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import software.amazon.jdbc.dialect.BlueGreenDialect;
import software.amazon.jdbc.dialect.MysqlDialect;
import software.amazon.jdbc.util.StringUtils;

public class RdsMysqlDialect
extends MysqlDialect
implements BlueGreenDialect {
    private static final String BG_STATUS_QUERY = "SELECT * FROM mysql.rds_topology";
    private static final String TOPOLOGY_TABLE_EXIST_QUERY = "SELECT 1 AS tmp FROM information_schema.tables WHERE table_schema = 'mysql' AND table_name = 'rds_topology'";
    private static final List<String> dialectUpdateCandidates = Arrays.asList("aurora-mysql", "rds-multi-az-mysql-cluster");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDialect(Connection connection) {
        if (super.isDialect(connection)) {
            return false;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(this.getServerVersionQuery());
            if (!rs.next()) {
                boolean bl = false;
                return bl;
            }
            String columnValue = rs.getString(2);
            if (!"Source distribution".equalsIgnoreCase(columnValue)) {
                boolean bl = false;
                return bl;
            }
            rs.close();
            rs = stmt.executeQuery("SHOW VARIABLES LIKE 'report_host'");
            if (!rs.next()) {
                boolean bl = false;
                return bl;
            }
            String reportHost = rs.getString(2);
            boolean bl = StringUtils.isNullOrEmpty(reportHost);
            return bl;
        }
        catch (SQLException sQLException) {
            return false;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public List<String> getDialectUpdateCandidates() {
        return dialectUpdateCandidates;
    }

    @Override
    public String getBlueGreenStatusQuery() {
        return BG_STATUS_QUERY;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isBlueGreenStatusAvailable(Connection connection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

