/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.failover;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.plugin.failover.FailoverRestriction;
import software.amazon.jdbc.plugin.failover.ReaderFailoverHandler;
import software.amazon.jdbc.plugin.failover.ReaderFailoverResult;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.Utils;

public class ClusterAwareReaderFailoverHandler
implements ReaderFailoverHandler {
    private static final Logger LOGGER = Logger.getLogger(ClusterAwareReaderFailoverHandler.class.getName());
    protected static final int DEFAULT_FAILOVER_TIMEOUT = 60000;
    protected static final int DEFAULT_READER_CONNECT_TIMEOUT = 30000;
    public static final ReaderFailoverResult FAILED_READER_FAILOVER_RESULT = new ReaderFailoverResult(null, null, false);
    protected Properties initialConnectionProps;
    protected int maxFailoverTimeoutMs;
    protected int timeoutMs;
    protected boolean isStrictReaderRequired;
    protected final PluginService pluginService;

    public ClusterAwareReaderFailoverHandler(PluginService pluginService, Properties initialConnectionProps) {
        this(pluginService, initialConnectionProps, 60000, 30000, false);
    }

    public ClusterAwareReaderFailoverHandler(PluginService pluginService, Properties initialConnectionProps, int maxFailoverTimeoutMs, int timeoutMs, boolean isStrictReaderRequired) {
        this.pluginService = pluginService;
        this.initialConnectionProps = initialConnectionProps;
        this.maxFailoverTimeoutMs = maxFailoverTimeoutMs;
        this.timeoutMs = timeoutMs;
        this.isStrictReaderRequired = isStrictReaderRequired;
    }

    protected void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    @Override
    public ReaderFailoverResult failover(List<HostSpec> hosts, HostSpec currentHost) throws SQLException {
        if (Utils.isNullOrEmpty(hosts)) {
            LOGGER.fine(() -> Messages.get("ClusterAwareReaderFailoverHandler.invalidTopology", new Object[]{"failover"}));
            return FAILED_READER_FAILOVER_RESULT;
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<ReaderFailoverResult> future = this.submitInternalFailoverTask(hosts, currentHost, executor);
        return this.getInternalFailoverResult(executor, future);
    }

    private Future<ReaderFailoverResult> submitInternalFailoverTask(List<HostSpec> hosts, HostSpec currentHost, ExecutorService executor) {
        Future<ReaderFailoverResult> future = executor.submit(() -> {
            try {
                while (true) {
                    ReaderFailoverResult result;
                    if ((result = this.failoverInternal(hosts, currentHost)) != null && result.isConnected()) {
                        return result;
                    }
                    TimeUnit.SECONDS.sleep(1L);
                }
            }
            catch (SQLException ex) {
                return new ReaderFailoverResult(null, null, false, ex);
            }
            catch (Exception ex) {
                return new ReaderFailoverResult(null, null, false, new SQLException(ex));
            }
        });
        executor.shutdown();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReaderFailoverResult getInternalFailoverResult(ExecutorService executor, Future<ReaderFailoverResult> future) throws SQLException {
        try {
            ReaderFailoverResult result = future.get(this.maxFailoverTimeoutMs, TimeUnit.MILLISECONDS);
            if (result == null) {
                LOGGER.warning(Messages.get("ClusterAwareReaderFailoverHandler.timeout", new Object[]{this.maxFailoverTimeoutMs}));
                ReaderFailoverResult readerFailoverResult = FAILED_READER_FAILOVER_RESULT;
                return readerFailoverResult;
            }
            ReaderFailoverResult readerFailoverResult = result;
            return readerFailoverResult;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException(Messages.get("ClusterAwareReaderFailoverHandler.interruptedThread"), "70100", e);
        }
        catch (ExecutionException e) {
            ReaderFailoverResult readerFailoverResult = FAILED_READER_FAILOVER_RESULT;
            return readerFailoverResult;
        }
        catch (TimeoutException e) {
            future.cancel(true);
            ReaderFailoverResult readerFailoverResult = FAILED_READER_FAILOVER_RESULT;
            return readerFailoverResult;
        }
        finally {
            if (!executor.isTerminated()) {
                executor.shutdownNow();
            }
        }
    }

    protected ReaderFailoverResult failoverInternal(List<HostSpec> hosts, HostSpec currentHost) throws SQLException {
        if (currentHost != null) {
            this.pluginService.setAvailability(currentHost.asAliases(), HostAvailability.NOT_AVAILABLE);
        }
        List<HostSpec> hostsByPriority = this.getHostsByPriority(hosts);
        return this.getConnectionFromHostGroup(hostsByPriority);
    }

    public List<HostSpec> getHostsByPriority(List<HostSpec> hosts) {
        ArrayList<HostSpec> activeReaders = new ArrayList<HostSpec>();
        ArrayList<HostSpec> downHostList = new ArrayList<HostSpec>();
        HostSpec writerHost = null;
        for (HostSpec host : hosts) {
            if (host.getRole() == HostRole.WRITER) {
                writerHost = host;
                continue;
            }
            if (host.getRawAvailability() == HostAvailability.AVAILABLE) {
                activeReaders.add(host);
                continue;
            }
            downHostList.add(host);
        }
        Collections.shuffle(activeReaders);
        Collections.shuffle(downHostList);
        ArrayList<HostSpec> hostsByPriority = new ArrayList<HostSpec>(activeReaders);
        int numOfReaders = activeReaders.size() + downHostList.size();
        if (writerHost != null || numOfReaders == 0) {
            hostsByPriority.add(writerHost);
        }
        hostsByPriority.addAll(downHostList);
        return hostsByPriority;
    }

    @Override
    public ReaderFailoverResult getReaderConnection(List<HostSpec> hostList) throws SQLException {
        if (Utils.isNullOrEmpty(hostList)) {
            LOGGER.fine(() -> Messages.get("ClusterAwareReaderFailover.invalidTopology", new Object[]{"getReaderConnection"}));
            return FAILED_READER_FAILOVER_RESULT;
        }
        List<HostSpec> hostsByPriority = this.getReaderHostsByPriority(hostList);
        return this.getConnectionFromHostGroup(hostsByPriority);
    }

    public List<HostSpec> getReaderHostsByPriority(List<HostSpec> hosts) {
        ArrayList<HostSpec> activeReaders = new ArrayList<HostSpec>();
        ArrayList<HostSpec> downHostList = new ArrayList<HostSpec>();
        HostSpec writerHost = null;
        for (HostSpec host : hosts) {
            if (host.getRole() == HostRole.WRITER) {
                writerHost = host;
                continue;
            }
            if (host.getRawAvailability() == HostAvailability.AVAILABLE) {
                activeReaders.add(host);
                continue;
            }
            downHostList.add(host);
        }
        Collections.shuffle(activeReaders);
        Collections.shuffle(downHostList);
        ArrayList<HostSpec> hostsByPriority = new ArrayList<HostSpec>();
        hostsByPriority.addAll(activeReaders);
        hostsByPriority.addAll(downHostList);
        int numOfReaders = activeReaders.size() + downHostList.size();
        if (writerHost != null && (numOfReaders == 0 || this.pluginService.getDialect().getFailoverRestrictions().contains((Object)FailoverRestriction.ENABLE_WRITER_IN_TASK_B))) {
            hostsByPriority.add(writerHost);
        }
        return hostsByPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReaderFailoverResult getConnectionFromHostGroup(List<HostSpec> hosts) throws SQLException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        ExecutorCompletionService<ReaderFailoverResult> completionService = new ExecutorCompletionService<ReaderFailoverResult>(executor);
        try {
            for (int i = 0; i < hosts.size(); i += 2) {
                ReaderFailoverResult result = this.getResultFromNextTaskBatch(hosts, executor, completionService, i);
                if (result.isConnected() || result.getException() != null) {
                    ReaderFailoverResult readerFailoverResult = result;
                    return readerFailoverResult;
                }
                try {
                    TimeUnit.SECONDS.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SQLException(Messages.get("ClusterAwareReaderFailoverHandler.interruptedThread"), "70100", e);
                }
            }
            ReaderFailoverResult readerFailoverResult = new ReaderFailoverResult(null, null, false);
            return readerFailoverResult;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private ReaderFailoverResult getResultFromNextTaskBatch(List<HostSpec> hosts, ExecutorService executor, CompletionService<ReaderFailoverResult> completionService, int i) throws SQLException {
        int numTasks = i + 1 < hosts.size() ? 2 : 1;
        completionService.submit(new ConnectionAttemptTask(hosts.get(i), this.isStrictReaderRequired));
        if (numTasks == 2) {
            completionService.submit(new ConnectionAttemptTask(hosts.get(i + 1), this.isStrictReaderRequired));
        }
        for (int taskNum = 0; taskNum < numTasks; ++taskNum) {
            ReaderFailoverResult result = this.getNextResult(completionService);
            if (result.isConnected()) {
                executor.shutdownNow();
                return result;
            }
            if (result.getException() == null) continue;
            executor.shutdownNow();
            return result;
        }
        return new ReaderFailoverResult(null, null, false);
    }

    private ReaderFailoverResult getNextResult(CompletionService<ReaderFailoverResult> service) throws SQLException {
        try {
            Future<ReaderFailoverResult> future = service.poll(this.timeoutMs, TimeUnit.MILLISECONDS);
            if (future == null) {
                return FAILED_READER_FAILOVER_RESULT;
            }
            ReaderFailoverResult result = future.get();
            return result == null ? FAILED_READER_FAILOVER_RESULT : result;
        }
        catch (ExecutionException e) {
            return FAILED_READER_FAILOVER_RESULT;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException(Messages.get("ClusterAwareReaderFailoverHandler.interruptedThread"), "70100", e);
        }
    }

    private class ConnectionAttemptTask
    implements Callable<ReaderFailoverResult> {
        private final HostSpec newHost;
        private final boolean isStrictReaderRequired;

        private ConnectionAttemptTask(HostSpec newHost, boolean isStrictReaderRequired) {
            this.newHost = newHost;
            this.isStrictReaderRequired = isStrictReaderRequired;
        }

        @Override
        public ReaderFailoverResult call() {
            LOGGER.fine(() -> Messages.get("ClusterAwareReaderFailoverHandler.attemptingReaderConnection", new Object[]{this.newHost.getUrl(), PropertyUtils.maskProperties(ClusterAwareReaderFailoverHandler.this.initialConnectionProps)}));
            try {
                Connection conn;
                block10: {
                    Properties copy = new Properties();
                    copy.putAll((Map<?, ?>)ClusterAwareReaderFailoverHandler.this.initialConnectionProps);
                    conn = ClusterAwareReaderFailoverHandler.this.pluginService.forceConnect(this.newHost, copy);
                    ClusterAwareReaderFailoverHandler.this.pluginService.setAvailability(this.newHost.asAliases(), HostAvailability.AVAILABLE);
                    if (this.isStrictReaderRequired) {
                        try {
                            HostRole role = ClusterAwareReaderFailoverHandler.this.pluginService.getHostRole(conn);
                            if (HostRole.READER.equals((Object)role)) break block10;
                            LOGGER.fine(Messages.get("ClusterAwareReaderFailoverHandler.readerRequired", new Object[]{this.newHost.getUrl(), role}));
                            try {
                                conn.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            return FAILED_READER_FAILOVER_RESULT;
                        }
                        catch (SQLException e) {
                            LOGGER.fine(Messages.get("ClusterAwareReaderFailoverHandler.errorGettingHostRole", new Object[]{e}));
                            try {
                                conn.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            return FAILED_READER_FAILOVER_RESULT;
                        }
                    }
                }
                LOGGER.fine(() -> Messages.get("ClusterAwareReaderFailoverHandler.successfulReaderConnection", new Object[]{this.newHost.getUrl()}));
                LOGGER.fine("New reader failover connection object: " + conn);
                return new ReaderFailoverResult(conn, this.newHost, true);
            }
            catch (SQLException e) {
                ClusterAwareReaderFailoverHandler.this.pluginService.setAvailability(this.newHost.asAliases(), HostAvailability.NOT_AVAILABLE);
                LOGGER.fine(() -> Messages.get("ClusterAwareReaderFailoverHandler.failedReaderConnection", new Object[]{this.newHost.getUrl()}));
                if (!ClusterAwareReaderFailoverHandler.this.pluginService.isNetworkException(e)) {
                    return new ReaderFailoverResult(null, null, false, e);
                }
                return FAILED_READER_FAILOVER_RESULT;
            }
        }
    }
}

