/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.hostlistprovider;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.hostlistprovider.StaticHostListProvider;
import software.amazon.jdbc.util.ConnectionUrlParser;
import software.amazon.jdbc.util.Messages;

public class ConnectionStringHostListProvider
implements StaticHostListProvider {
    private static final Logger LOGGER = Logger.getLogger(ConnectionStringHostListProvider.class.getName());
    final List<HostSpec> hostList = new ArrayList<HostSpec>();
    Properties properties;
    private boolean isInitialized = false;
    private final boolean isSingleWriterConnectionString;
    private final ConnectionUrlParser connectionUrlParser;
    private final String initialUrl;
    private final HostListProviderService hostListProviderService;
    public static final AwsWrapperProperty SINGLE_WRITER_CONNECTION_STRING = new AwsWrapperProperty("singleWriterConnectionString", "false", "Set to true if you are providing a connection string with multiple comma-delimited hosts and your cluster has only one writer. The writer must be the first host in the connection string");

    public ConnectionStringHostListProvider(@NonNull Properties properties, String initialUrl, @NonNull HostListProviderService hostListProviderService) {
        this(properties, initialUrl, hostListProviderService, new ConnectionUrlParser());
    }

    ConnectionStringHostListProvider(@NonNull Properties properties, String initialUrl, @NonNull HostListProviderService hostListProviderService, @NonNull ConnectionUrlParser connectionUrlParser) {
        this.isSingleWriterConnectionString = SINGLE_WRITER_CONNECTION_STRING.getBoolean(properties);
        this.initialUrl = initialUrl;
        this.connectionUrlParser = connectionUrlParser;
        this.hostListProviderService = hostListProviderService;
    }

    private void init() throws SQLException {
        if (this.isInitialized) {
            return;
        }
        this.hostList.addAll(this.connectionUrlParser.getHostsFromConnectionUrl(this.initialUrl, this.isSingleWriterConnectionString, () -> this.hostListProviderService.getHostSpecBuilder()));
        if (this.hostList.isEmpty()) {
            throw new SQLException(Messages.get("ConnectionStringHostListProvider.parsedListEmpty", new Object[]{this.initialUrl}));
        }
        this.hostListProviderService.setInitialConnectionHostSpec(this.hostList.get(0));
        this.isInitialized = true;
    }

    @Override
    public List<HostSpec> refresh() throws SQLException {
        this.init();
        return Collections.unmodifiableList(this.hostList);
    }

    @Override
    public List<HostSpec> refresh(Connection connection) throws SQLException {
        this.init();
        return this.refresh();
    }

    @Override
    public List<HostSpec> forceRefresh() throws SQLException {
        this.init();
        return Collections.unmodifiableList(this.hostList);
    }

    @Override
    public List<HostSpec> forceRefresh(Connection connection) throws SQLException {
        this.init();
        return this.forceRefresh();
    }

    @Override
    public HostRole getHostRole(Connection connection) {
        throw new UnsupportedOperationException("ConnectionStringHostListProvider does not support getHostRole");
    }

    @Override
    public HostSpec identifyConnection(Connection connection) throws SQLException {
        LOGGER.finest(Messages.get("ConnectionStringHostListProvider.unsupportedIdentifyConnection"));
        return null;
    }

    @Override
    public String getClusterId() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ConnectionStringHostListProvider does not support `getClusterId` method.");
    }
}

