/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.Driver;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.cleanup.CanReleaseResources;

public class ConnectionProviderManager {
    private final ConnectionProvider defaultProvider;
    private final @Nullable ConnectionProvider effectiveConnProvider;

    public ConnectionProviderManager(ConnectionProvider defaultProvider, @Nullable ConnectionProvider effectiveConnProvider) {
        this.defaultProvider = defaultProvider;
        this.effectiveConnProvider = effectiveConnProvider;
    }

    @Deprecated
    public static void setConnectionProvider(ConnectionProvider connProvider) {
        Driver.setCustomConnectionProvider(connProvider);
    }

    public ConnectionProvider getConnectionProvider(String driverProtocol, HostSpec host, Properties props) {
        ConnectionProvider customConnectionProvider = Driver.getCustomConnectionProvider();
        if (customConnectionProvider != null && customConnectionProvider.acceptsUrl(driverProtocol, host, props)) {
            return customConnectionProvider;
        }
        if (this.effectiveConnProvider != null && this.effectiveConnProvider.acceptsUrl(driverProtocol, host, props)) {
            return this.effectiveConnProvider;
        }
        return this.defaultProvider;
    }

    public ConnectionProvider getDefaultProvider() {
        return this.defaultProvider;
    }

    public boolean acceptsStrategy(HostRole role, String strategy) {
        ConnectionProvider customConnectionProvider = Driver.getCustomConnectionProvider();
        if (customConnectionProvider != null && customConnectionProvider.acceptsStrategy(role, strategy)) {
            return true;
        }
        if (this.effectiveConnProvider != null && this.effectiveConnProvider.acceptsStrategy(role, strategy)) {
            return true;
        }
        return this.defaultProvider.acceptsStrategy(role, strategy);
    }

    public HostSpec getHostSpecByStrategy(List<HostSpec> hosts, HostRole role, String strategy, Properties props) throws SQLException, UnsupportedOperationException {
        HostSpec host = null;
        ConnectionProvider customConnectionProvider = Driver.getCustomConnectionProvider();
        try {
            if (customConnectionProvider != null && customConnectionProvider.acceptsStrategy(role, strategy)) {
                host = customConnectionProvider.getHostSpecByStrategy(hosts, role, strategy, props);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (host != null) {
            return host;
        }
        if (this.effectiveConnProvider != null && this.effectiveConnProvider.acceptsStrategy(role, strategy) && (host = this.effectiveConnProvider.getHostSpecByStrategy(hosts, role, strategy, props)) != null) {
            return host;
        }
        return this.defaultProvider.getHostSpecByStrategy(hosts, role, strategy, props);
    }

    @Deprecated
    public static void resetProvider() {
        Driver.resetCustomConnectionProvider();
    }

    public static void releaseResources() {
        ConnectionProvider customConnectionProvider = Driver.getCustomConnectionProvider();
        if (customConnectionProvider instanceof CanReleaseResources) {
            ((CanReleaseResources)((Object)customConnectionProvider)).releaseResources();
        }
    }

    @Deprecated
    public static void setConnectionInitFunc(@NonNull ConnectionInitFunc func) {
        Driver.setConnectionInitFunc(func);
    }

    @Deprecated
    public static void resetConnectionInitFunc() {
        Driver.resetConnectionInitFunc();
    }

    public void initConnection(@Nullable Connection connection, @NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        ConnectionInitFunc connectionInitFunc = Driver.getConnectionInitFunc();
        if (connectionInitFunc == null) {
            return;
        }
        connectionInitFunc.initConnection(connection, protocol, hostSpec, props);
    }

    public static interface ConnectionInitFunc {
        public void initConnection(@Nullable Connection var1, @NonNull String var2, @NonNull HostSpec var3, @NonNull Properties var4) throws SQLException;
    }
}

