/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.impl.AbstractPoolBackedDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSelector;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PooledConnectionProvider;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.RandomHostSelector;
import software.amazon.jdbc.RoundRobinHostSelector;
import software.amazon.jdbc.cleanup.CanReleaseResources;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.targetdriverdialect.ConnectInfo;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.SlidingExpirationCache;
import software.amazon.jdbc.wrapper.HighestWeightHostSelector;

public class C3P0PooledConnectionProvider
implements PooledConnectionProvider,
CanReleaseResources {
    private static final Logger LOGGER = Logger.getLogger(C3P0PooledConnectionProvider.class.getName());
    protected static final SlidingExpirationCache<String, ComboPooledDataSource> databasePools = new SlidingExpirationCache(null, AbstractPoolBackedDataSource::close);
    protected static final Map<String, HostSelector> acceptedStrategies = Collections.unmodifiableMap(new HashMap<String, HostSelector>(){
        {
            this.put("highestWeight", new HighestWeightHostSelector());
            this.put("random", new RandomHostSelector());
            this.put("roundRobin", new RoundRobinHostSelector());
        }
    });
    protected static final long poolExpirationCheckNanos = TimeUnit.MINUTES.toNanos(30L);

    @Override
    public boolean acceptsUrl(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) {
        return true;
    }

    @Override
    public boolean acceptsStrategy(@NonNull HostRole role, @NonNull String strategy) {
        return acceptedStrategies.containsKey(strategy);
    }

    @Override
    public HostSpec getHostSpecByStrategy(@NonNull List<HostSpec> hosts, @NonNull HostRole role, @NonNull String strategy, @Nullable Properties props) throws SQLException, UnsupportedOperationException {
        if (!this.acceptsStrategy(role, strategy)) {
            throw new UnsupportedOperationException(Messages.get("ConnectionProvider.unsupportedHostSpecSelectorStrategy", new Object[]{strategy, C3P0PooledConnectionProvider.class}));
        }
        return acceptedStrategies.get(strategy).getHost(hosts, role, props);
    }

    @Override
    public Connection connect(@NonNull String protocol, @NonNull Dialect dialect, @NonNull TargetDriverDialect targetDriverDialect, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        Properties copy = PropertyUtils.copyProperties(props);
        dialect.prepareConnectProperties(copy, protocol, hostSpec);
        ComboPooledDataSource ds = databasePools.computeIfAbsent(hostSpec.getUrl(), key -> this.createDataSource(protocol, hostSpec, copy, targetDriverDialect), poolExpirationCheckNanos);
        ds.setPassword(copy.getProperty(PropertyDefinition.PASSWORD.name));
        return ds.getConnection();
    }

    protected ComboPooledDataSource createDataSource(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props, TargetDriverDialect driverDialect) {
        ConnectInfo connectInfo;
        try {
            connectInfo = driverDialect.prepareConnectInfo(protocol, hostSpec, props);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        StringBuilder urlBuilder = new StringBuilder(connectInfo.url);
        StringJoiner propsJoiner = new StringJoiner("&");
        connectInfo.props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (!PropertyDefinition.PASSWORD.name.equals(k) && !PropertyDefinition.USER.name.equals(k)) {
                propsJoiner.add(k + "=" + v);
            }
        }));
        urlBuilder.append(connectInfo.url.contains("?") ? "&" : "?").append(propsJoiner);
        ComboPooledDataSource ds = new ComboPooledDataSource();
        ds.setJdbcUrl(urlBuilder.toString());
        String user = connectInfo.props.getProperty(PropertyDefinition.USER.name);
        String password = connectInfo.props.getProperty(PropertyDefinition.PASSWORD.name);
        if (user != null) {
            ds.setUser(user);
        }
        if (password != null) {
            ds.setPassword(password);
        }
        return ds;
    }

    @Override
    public String getTargetName() {
        return C3P0PooledConnectionProvider.class.getName();
    }

    @Override
    public void releaseResources() {
        databasePools.getEntries().forEach((key, pool) -> pool.close());
        databasePools.clear();
    }
}

