/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.federatedauth;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.TokenInfo;
import software.amazon.jdbc.plugin.federatedauth.CredentialsProviderFactory;
import software.amazon.jdbc.plugin.federatedauth.FederatedAuthCacheHolder;
import software.amazon.jdbc.plugin.federatedauth.SamlUtils;
import software.amazon.jdbc.plugin.iam.IamTokenUtility;
import software.amazon.jdbc.util.IamAuthUtils;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.RegionUtils;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryGauge;

public class FederatedAuthPlugin
extends AbstractConnectionPlugin {
    private final CredentialsProviderFactory credentialsProviderFactory;
    private static final int DEFAULT_TOKEN_EXPIRATION_SEC = 870;
    private static final int DEFAULT_HTTP_TIMEOUT_MILLIS = 60000;
    public static final AwsWrapperProperty IDP_ENDPOINT = new AwsWrapperProperty("idpEndpoint", null, "The hosting URL of the Identity Provider");
    public static final AwsWrapperProperty IDP_PORT = new AwsWrapperProperty("idpPort", "443", "The hosting port of Identity Provider");
    public static final AwsWrapperProperty RELAYING_PARTY_ID = new AwsWrapperProperty("rpIdentifier", "urn:amazon:webservices", "The relaying party identifier");
    public static final AwsWrapperProperty IAM_ROLE_ARN = new AwsWrapperProperty("iamRoleArn", null, "The ARN of the IAM Role that is to be assumed.");
    public static final AwsWrapperProperty IAM_IDP_ARN = new AwsWrapperProperty("iamIdpArn", null, "The ARN of the Identity Provider");
    public static final AwsWrapperProperty IAM_REGION = new AwsWrapperProperty("iamRegion", null, "Overrides AWS region that is used to generate the IAM token");
    public static final AwsWrapperProperty IAM_TOKEN_EXPIRATION = new AwsWrapperProperty("iamTokenExpiration", String.valueOf(870), "IAM token cache expiration in seconds");
    public static final AwsWrapperProperty IDP_USERNAME = new AwsWrapperProperty("idpUsername", null, "The federated user name");
    public static final AwsWrapperProperty IDP_PASSWORD = new AwsWrapperProperty("idpPassword", null, "The federated user password");
    public static final AwsWrapperProperty IAM_HOST = new AwsWrapperProperty("iamHost", null, "Overrides the host that is used to generate the IAM token");
    public static final AwsWrapperProperty IAM_DEFAULT_PORT = new AwsWrapperProperty("iamDefaultPort", "-1", "Overrides default port that is used to generate the IAM token");
    public static final AwsWrapperProperty HTTP_CLIENT_SOCKET_TIMEOUT = new AwsWrapperProperty("httpClientSocketTimeout", String.valueOf(60000), "The socket timeout value in milliseconds for the HttpClient used by the FederatedAuthPlugin");
    public static final AwsWrapperProperty HTTP_CLIENT_CONNECT_TIMEOUT = new AwsWrapperProperty("httpClientConnectTimeout", String.valueOf(60000), "The connect timeout value in milliseconds for the HttpClient used by the FederatedAuthPlugin");
    public static final AwsWrapperProperty SSL_INSECURE = new AwsWrapperProperty("sslInsecure", "true", "Whether or not the SSL session is to be secure and the sever's certificates will be verified");
    public static AwsWrapperProperty IDP_NAME = new AwsWrapperProperty("idpName", "adfs", "The name of the Identity Provider implementation used");
    public static final AwsWrapperProperty DB_USER = new AwsWrapperProperty("dbUser", null, "The database user used to access the database");
    protected static final Pattern SAML_RESPONSE_PATTERN = Pattern.compile("SAMLResponse\\W+value=\"(?<saml>[^\"]+)\"");
    protected static final String SAML_RESPONSE_PATTERN_GROUP = "saml";
    protected static final RegionUtils regionUtils = new RegionUtils();
    private static final Logger LOGGER = Logger.getLogger(FederatedAuthPlugin.class.getName());
    protected final PluginService pluginService;
    protected final RdsUtils rdsUtils;
    protected final SamlUtils samlUtils;
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("connect");
            this.add("forceConnect");
        }
    });
    private final TelemetryFactory telemetryFactory;
    private final TelemetryGauge cacheSizeGauge;
    private final TelemetryCounter fetchTokenCounter;
    private final IamTokenUtility iamTokenUtility;

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    public FederatedAuthPlugin(PluginService pluginService, CredentialsProviderFactory credentialsProviderFactory) {
        this(pluginService, credentialsProviderFactory, new RdsUtils(), IamAuthUtils.getTokenUtility());
    }

    FederatedAuthPlugin(PluginService pluginService, CredentialsProviderFactory credentialsProviderFactory, RdsUtils rdsUtils, IamTokenUtility tokenUtils) {
        try {
            Class.forName("software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest");
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("shaded.software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest");
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException(Messages.get("SamlAuthPlugin.javaStsSdkNotInClasspath"));
            }
        }
        this.pluginService = pluginService;
        this.credentialsProviderFactory = credentialsProviderFactory;
        this.telemetryFactory = pluginService.getTelemetryFactory();
        this.cacheSizeGauge = this.telemetryFactory.createGauge("federatedAuth.tokenCache.size", () -> FederatedAuthCacheHolder.tokenCache.size());
        this.fetchTokenCounter = this.telemetryFactory.createCounter("federatedAuth.fetchToken.count");
        this.rdsUtils = rdsUtils;
        this.samlUtils = new SamlUtils(this.rdsUtils);
        this.iamTokenUtility = tokenUtils;
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        return this.connectInternal(hostSpec, props, connectFunc);
    }

    @Override
    public Connection forceConnect(@NonNull String driverProtocol, @NonNull HostSpec hostSpec, @NonNull Properties props, boolean isInitialConnection, @NonNull JdbcCallable<Connection, SQLException> forceConnectFunc) throws SQLException {
        return this.connectInternal(hostSpec, props, forceConnectFunc);
    }

    private Connection connectInternal(HostSpec hostSpec, Properties props, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        boolean isCachedToken;
        this.samlUtils.checkIdpCredentialsWithFallback(IDP_USERNAME, IDP_PASSWORD, props);
        String host = IamAuthUtils.getIamHost(IAM_HOST.getString(props), hostSpec);
        int port = IamAuthUtils.getIamPort(IAM_DEFAULT_PORT.getInteger(props), hostSpec, this.pluginService.getDialect().getDefaultPort());
        Region region = regionUtils.getRegion(host, props, FederatedAuthPlugin.IAM_REGION.name);
        if (region == null) {
            throw new SQLException(Messages.get("FederatedAuthPlugin.unableToDetermineRegion", new Object[]{FederatedAuthPlugin.IAM_REGION.name}));
        }
        String cacheKey = IamAuthUtils.getCacheKey(DB_USER.getString(props), host, port, region);
        TokenInfo tokenInfo = FederatedAuthCacheHolder.tokenCache.get(cacheKey);
        boolean bl = isCachedToken = tokenInfo != null && !tokenInfo.isExpired();
        if (isCachedToken) {
            LOGGER.finest(() -> Messages.get("AuthenticationToken.useCachedToken", new Object[]{tokenInfo.getToken()}));
            PropertyDefinition.PASSWORD.set(props, tokenInfo.getToken());
        } else {
            this.updateAuthenticationToken(hostSpec, props, region, cacheKey, host);
        }
        PropertyDefinition.USER.set(props, DB_USER.getString(props));
        try {
            return connectFunc.call();
        }
        catch (SQLException exception) {
            this.updateAuthenticationToken(hostSpec, props, region, cacheKey, host);
            return connectFunc.call();
        }
        catch (Exception exception) {
            LOGGER.warning(() -> Messages.get("SamlAuthPlugin.unhandledException", new Object[]{exception}));
            throw new SQLException(exception);
        }
    }

    private void updateAuthenticationToken(HostSpec hostSpec, Properties props, Region region, String cacheKey, String host) throws SQLException {
        int tokenExpirationSec = IAM_TOKEN_EXPIRATION.getInteger(props);
        Instant tokenExpiry = Instant.now().plus((long)tokenExpirationSec, ChronoUnit.SECONDS);
        int port = IamAuthUtils.getIamPort(StringUtils.isNullOrEmpty(IAM_DEFAULT_PORT.getString(props)) ? 0 : IAM_DEFAULT_PORT.getInteger(props), hostSpec, this.pluginService.getDialect().getDefaultPort());
        AwsCredentialsProvider credentialsProvider = this.credentialsProviderFactory.getAwsCredentialsProvider(hostSpec.getHost(), region, props);
        this.fetchTokenCounter.inc();
        String token = IamAuthUtils.generateAuthenticationToken(this.iamTokenUtility, this.pluginService, DB_USER.getString(props), host, port, region, credentialsProvider);
        LOGGER.finest(() -> Messages.get("AuthenticationToken.useCachedToken", new Object[]{token}));
        PropertyDefinition.PASSWORD.set(props, token);
        FederatedAuthCacheHolder.tokenCache.put(cacheKey, new TokenInfo(token, tokenExpiry));
    }

    public static void clearCache() {
        FederatedAuthCacheHolder.clearCache();
    }

    static {
        PropertyDefinition.registerPluginProperties(FederatedAuthPlugin.class);
    }
}

