/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.efm2.Monitor;
import software.amazon.jdbc.plugin.efm2.MonitorConnectionContext;
import software.amazon.jdbc.plugin.efm2.MonitorImpl;
import software.amazon.jdbc.plugin.efm2.MonitorInitializer;
import software.amazon.jdbc.plugin.efm2.MonitorService;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.SlidingExpirationCacheWithCleanupThread;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;

public class MonitorServiceImpl
implements MonitorService {
    private static final Logger LOGGER = Logger.getLogger(MonitorServiceImpl.class.getName());
    public static final AwsWrapperProperty MONITOR_DISPOSAL_TIME_MS = new AwsWrapperProperty("monitorDisposalTime", "600000", "Interval in milliseconds for a monitor to be considered inactive and to be disposed.");
    protected static final long CACHE_CLEANUP_NANO = TimeUnit.MINUTES.toNanos(1L);
    protected static final Executor ABORT_EXECUTOR = Executors.newSingleThreadExecutor();
    protected static final SlidingExpirationCacheWithCleanupThread<String, Monitor> monitors = new SlidingExpirationCacheWithCleanupThread(Monitor::canDispose, monitor -> {
        try {
            monitor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }, CACHE_CLEANUP_NANO);
    protected final PluginService pluginService;
    protected final MonitorInitializer monitorInitializer;
    protected final TelemetryFactory telemetryFactory;
    protected final TelemetryCounter abortedConnectionsCounter;

    public MonitorServiceImpl(@NonNull PluginService pluginService) {
        this(pluginService, (hostSpec, properties, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount, abortedConnectionsCounter) -> new MonitorImpl(pluginService, hostSpec, properties, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount, abortedConnectionsCounter));
    }

    MonitorServiceImpl(@NonNull PluginService pluginService, @NonNull MonitorInitializer monitorInitializer) {
        this.pluginService = pluginService;
        this.telemetryFactory = pluginService.getTelemetryFactory();
        this.abortedConnectionsCounter = this.telemetryFactory.createCounter("efm2.connections.aborted");
        this.monitorInitializer = monitorInitializer;
    }

    public static void closeAllMonitors() {
        monitors.getEntries().values().forEach(monitor -> {
            try {
                monitor.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        monitors.clear();
    }

    @Override
    public MonitorConnectionContext startMonitoring(Connection connectionToAbort, HostSpec hostSpec, Properties properties, int failureDetectionTimeMillis, int failureDetectionIntervalMillis, int failureDetectionCount) {
        Monitor monitor = this.getMonitor(hostSpec, properties, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount);
        MonitorConnectionContext context = new MonitorConnectionContext(connectionToAbort);
        monitor.startMonitoring(context);
        return context;
    }

    @Override
    public void stopMonitoring(@NonNull MonitorConnectionContext context, @NonNull Connection connectionToAbort) {
        if (context.shouldAbort()) {
            context.setInactive();
            try {
                connectionToAbort.abort(ABORT_EXECUTOR);
                connectionToAbort.close();
                this.abortedConnectionsCounter.inc();
            }
            catch (SQLException sqlEx) {
                LOGGER.finest(() -> Messages.get("MonitorConnectionContext.exceptionAbortingConnection", new Object[]{sqlEx.getMessage()}));
            }
        } else {
            context.setInactive();
        }
    }

    @Override
    public void releaseResources() {
    }

    protected Monitor getMonitor(HostSpec hostSpec, Properties properties, int failureDetectionTimeMillis, int failureDetectionIntervalMillis, int failureDetectionCount) {
        String monitorKey = String.format("%d:%d:%d:%s", failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount, hostSpec.getUrl());
        long cacheExpirationNano = TimeUnit.MILLISECONDS.toNanos(MONITOR_DISPOSAL_TIME_MS.getLong(properties));
        return monitors.computeIfAbsent(monitorKey, key -> this.monitorInitializer.createMonitor(hostSpec, properties, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount, this.abortedConnectionsCounter), cacheExpirationNano);
    }
}

