/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.exceptions;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.SQLLoginException;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.util.StringUtils;

public class GenericExceptionHandler
implements ExceptionHandler {
    static final List<String> ACCESS_ERRORS = Arrays.asList("28000", "28P01");
    static final List<String> NETWORK_ERRORS = Arrays.asList("53", "57P01", "57P02", "57P03", "58", "99", "F0", "XX", "08");

    @Override
    public boolean isNetworkException(Throwable throwable) {
        return this.isNetworkException(throwable, null);
    }

    @Override
    public boolean isNetworkException(Throwable throwable, @Nullable TargetDriverDialect targetDriverDialect) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            String sqlState;
            if (exception instanceof SQLException) {
                return this.isNetworkException(((SQLException)exception).getSQLState());
            }
            if (targetDriverDialect == null || StringUtils.isNullOrEmpty(sqlState = targetDriverDialect.getSQLState(throwable))) continue;
            return this.isNetworkException(sqlState);
        }
        return false;
    }

    @Override
    public boolean isNetworkException(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        for (String errors : NETWORK_ERRORS) {
            if (!sqlState.startsWith(errors)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLoginException(Throwable throwable) {
        return this.isLoginException(throwable, null);
    }

    @Override
    public boolean isLoginException(Throwable throwable, TargetDriverDialect targetDriverDialect) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            if (exception instanceof SQLLoginException) {
                return true;
            }
            String sqlState = null;
            if (exception instanceof SQLException) {
                sqlState = ((SQLException)exception).getSQLState();
            } else if (targetDriverDialect != null) {
                sqlState = targetDriverDialect.getSQLState(throwable);
            }
            if (!this.isLoginException(sqlState)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLoginException(String sqlState) {
        return ACCESS_ERRORS.contains(sqlState);
    }
}

