/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.telemetry;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import software.amazon.jdbc.util.telemetry.GaugeCallable;
import software.amazon.jdbc.util.telemetry.OpenTelemetryContext;
import software.amazon.jdbc.util.telemetry.OpenTelemetryCounter;
import software.amazon.jdbc.util.telemetry.OpenTelemetryGauge;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryGauge;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class OpenTelemetryFactory
implements TelemetryFactory {
    private static final String INSTRUMENTATION_NAME = "aws-advanced-jdbc-wrapper";
    private static final int NAME_MAX_LENGTH = 63;
    private static Tracer tracer;
    private static Meter meter;

    private static OpenTelemetry getOpenTelemetry() {
        return GlobalOpenTelemetry.get();
    }

    @Override
    public TelemetryContext openTelemetryContext(String name, TelemetryTraceLevel traceLevel) {
        tracer = OpenTelemetryFactory.getOpenTelemetry().getTracer(INSTRUMENTATION_NAME);
        return new OpenTelemetryContext(tracer, name, traceLevel);
    }

    @Override
    public void postCopy(TelemetryContext telemetryContext, TelemetryTraceLevel traceLevel) {
        if (!(telemetryContext instanceof OpenTelemetryContext)) {
            throw new RuntimeException("Wrong parameter type: " + telemetryContext.getClass().getName());
        }
        OpenTelemetryContext.postCopy((OpenTelemetryContext)telemetryContext, traceLevel);
    }

    @Override
    public TelemetryCounter createCounter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        meter = OpenTelemetryFactory.getOpenTelemetry().getMeter(INSTRUMENTATION_NAME);
        return new OpenTelemetryCounter(meter, this.trimName(name));
    }

    @Override
    public TelemetryGauge createGauge(String name, GaugeCallable<Long> callback) {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        meter = OpenTelemetryFactory.getOpenTelemetry().getMeter(INSTRUMENTATION_NAME);
        return new OpenTelemetryGauge(meter, this.trimName(name), callback);
    }

    private String trimName(String name) {
        return name.length() > 63 ? name.substring(0, 63) : name;
    }
}

