/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.iam;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.CredentialUtils;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4PresignerParams;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.jdbc.plugin.iam.IamTokenUtility;

public class LightRdsUtility
implements IamTokenUtility {
    private static final Logger LOGGER = Logger.getLogger(LightRdsUtility.class.getName());
    private static final Duration EXPIRATION_DURATION = Duration.ofMinutes(15L);

    @Override
    public String generateAuthenticationToken(@NonNull AwsCredentialsProvider credentialsProvider, @NonNull Region region, @NonNull String hostname, int port, @NonNull String username) {
        Clock clock = Clock.systemUTC();
        Aws4Signer signer = Aws4Signer.create();
        SdkHttpFullRequest httpRequest = SdkHttpFullRequest.builder().method(SdkHttpMethod.GET).protocol("https").host(hostname).port(Integer.valueOf(port)).encodedPath("/").putRawQueryParameter("DBUser", username).putRawQueryParameter("Action", "connect").build();
        Instant expirationTime = Instant.now(clock).plus(EXPIRATION_DURATION);
        AwsCredentials credentials = CredentialUtils.toCredentials((AwsCredentialsIdentity)((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)credentialsProvider.resolveIdentity())));
        Aws4PresignerParams presignRequest = ((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)Aws4PresignerParams.builder().signingClockOverride(clock)).expirationTime(expirationTime).awsCredentials(credentials)).signingName("rds-db")).signingRegion(region)).build();
        SdkHttpFullRequest fullRequest = signer.presign(httpRequest, presignRequest);
        String signedUrl = fullRequest.getUri().toString();
        String result = StringUtils.replacePrefixIgnoreCase((String)signedUrl, (String)"https://", (String)"");
        LOGGER.finest(() -> "Generated RDS authentication token with expiration of " + expirationTime);
        return result;
    }
}

