/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.federatedauth;

import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUtils;

public class SamlUtils {
    private static final Pattern HTTPS_URL_PATTERN = Pattern.compile("^(https)://[-a-zA-Z0-9+&@#/%?=~_!:,.']*[-a-zA-Z0-9+&@#/%=~_']");
    final RdsUtils rdsUtils;

    public SamlUtils(PluginService pluginService) {
        this(new RdsUtils());
    }

    SamlUtils(RdsUtils rdsUtils) {
        this.rdsUtils = rdsUtils;
    }

    void checkIdpCredentialsWithFallback(AwsWrapperProperty idpUserNameProperty, AwsWrapperProperty idpPasswordProperty, Properties props) {
        if (idpUserNameProperty.getString(props) == null) {
            idpUserNameProperty.set(props, PropertyDefinition.USER.getString(props));
        }
        if (idpPasswordProperty.getString(props) == null) {
            idpPasswordProperty.set(props, PropertyDefinition.PASSWORD.getString(props));
        }
    }

    static void validateUrl(String paramString) throws IOException {
        URI authorizeRequestUrl = URI.create(paramString);
        String errorMessage = Messages.get("AdfsCredentialsProviderFactory.invalidHttpsUrl", new Object[]{paramString});
        if (!authorizeRequestUrl.toURL().getProtocol().equalsIgnoreCase("https")) {
            throw new IOException(errorMessage);
        }
        Matcher matcher = HTTPS_URL_PATTERN.matcher(paramString);
        if (!matcher.find()) {
            throw new IOException(errorMessage);
        }
    }
}

