/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.limitless;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.HostSpecBuilder;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.RoundRobinHostSelector;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.hostavailability.SimpleHostAvailabilityStrategy;
import software.amazon.jdbc.plugin.limitless.LimitlessConnectionPlugin;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.SynchronousExecutor;
import software.amazon.jdbc.util.Utils;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class LimitlessRouterMonitor
implements AutoCloseable,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(LimitlessRouterMonitor.class.getName());
    private static final String MONITORING_PROPERTY_PREFIX = "limitless-router-monitor-";
    private final int intervalMs;
    private final @NonNull HostSpec hostSpec;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final AtomicReference<List<HostSpec>> limitlessRouters = new AtomicReference(Collections.unmodifiableList(new ArrayList()));
    private final @NonNull Properties props;
    private final @NonNull PluginService pluginService;
    private final TelemetryFactory telemetryFactory;
    private Connection monitoringConn = null;
    final Executor networkTimeoutExecutor = new SynchronousExecutor();
    static final int defaultQueryTimeoutMs = 5000;
    private final ExecutorService threadPool = Executors.newFixedThreadPool(1, runnableTarget -> {
        Thread monitoringThread = new Thread(runnableTarget);
        monitoringThread.setDaemon(true);
        return monitoringThread;
    });
    private final ReentrantLock lock = new ReentrantLock();

    public LimitlessRouterMonitor(@NonNull PluginService pluginService, @NonNull HostSpec hostSpec, @NonNull Properties props, int intervalMs) {
        this.pluginService = pluginService;
        this.hostSpec = hostSpec;
        this.props = PropertyUtils.copyProperties(props);
        props.stringPropertyNames().stream().filter(p -> p.startsWith(MONITORING_PROPERTY_PREFIX)).forEach(p -> {
            this.props.put(p.substring(MONITORING_PROPERTY_PREFIX.length()), this.props.getProperty((String)p));
            this.props.remove(p);
        });
        this.props.setProperty(LimitlessConnectionPlugin.WAIT_F0R_ROUTER_INFO.name, "false");
        this.intervalMs = intervalMs;
        this.telemetryFactory = this.pluginService.getTelemetryFactory();
        this.threadPool.submit(this);
        this.threadPool.shutdown();
    }

    public List<HostSpec> getLimitlessRouters() {
        return this.limitlessRouters.get();
    }

    public AtomicBoolean isStopped() {
        return this.stopped;
    }

    @Override
    public void close() throws Exception {
        this.stopped.set(true);
        if (!this.threadPool.awaitTermination(5L, TimeUnit.SECONDS)) {
            this.threadPool.shutdownNow();
        }
        LOGGER.finest(() -> Messages.get("LimitlessRouterMonitor.stopped", new Object[]{this.hostSpec.getHost()}));
    }

    @Override
    public void run() {
        LOGGER.finest(() -> Messages.get("LimitlessRouterMonitor.running", new Object[]{this.hostSpec.getHost()}));
        while (!this.stopped.get()) {
            TelemetryContext telemetryContext = this.telemetryFactory.openTelemetryContext("node response time thread", TelemetryTraceLevel.TOP_LEVEL);
            telemetryContext.setAttribute("url", this.hostSpec.getUrl());
            try {
                this.openConnection();
                if (this.monitoringConn == null || this.monitoringConn.isClosed()) continue;
                List<HostSpec> newLimitlessRouters = this.queryForLimitlessRouters(this.monitoringConn);
                this.limitlessRouters.set(Collections.unmodifiableList(newLimitlessRouters));
                RoundRobinHostSelector.setRoundRobinHostWeightPairsProperty(this.props, newLimitlessRouters);
                LOGGER.finest(Utils.logTopology(this.limitlessRouters.get(), "[limitlessRouterMonitor]"));
                TimeUnit.MILLISECONDS.sleep(this.intervalMs);
            }
            catch (InterruptedException exception) {
                LOGGER.finest(() -> Messages.get("LimitlessRouterMonitor.interruptedExceptionDuringMonitoring", new Object[]{this.hostSpec.getHost()}));
            }
            catch (Exception ex) {
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                LOGGER.log(Level.FINEST, Messages.get("LimitlessRouterMonitor.exceptionDuringMonitoringStop", new Object[]{this.hostSpec.getHost()}), ex);
            }
            finally {
                if (telemetryContext == null) continue;
                telemetryContext.closeContext();
            }
        }
    }

    public List<HostSpec> forceGetLimitlessRouters() throws SQLException {
        LOGGER.finest(Messages.get("LimitlessRouterMonitor.forceGetLimitlessRouters"));
        this.lock.lock();
        try {
            this.openConnection();
            if (this.monitoringConn == null || this.monitoringConn.isClosed()) {
                throw new SQLException(Messages.get("LimitlessRouterMonitor.forceGetLimitlessRoutersFailed"));
            }
            List<HostSpec> newLimitlessRouters = this.queryForLimitlessRouters(this.monitoringConn);
            this.limitlessRouters.set(Collections.unmodifiableList(newLimitlessRouters));
            RoundRobinHostSelector.setRoundRobinHostWeightPairsProperty(this.props, newLimitlessRouters);
            LOGGER.finest(Utils.logTopology(this.limitlessRouters.get(), "[limitlessRouterMonitor]"));
            List<HostSpec> list = newLimitlessRouters;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void openConnection() throws SQLException {
        try {
            if (this.monitoringConn == null || this.monitoringConn.isClosed()) {
                LOGGER.finest(() -> Messages.get("LimitlessRouterMonitor.openingConnection", new Object[]{this.hostSpec.getUrl()}));
                this.monitoringConn = this.pluginService.forceConnect(this.hostSpec, this.props);
                LOGGER.finest(() -> Messages.get("LimitlessRouterMonitor.openedConnection", new Object[]{this.monitoringConn}));
            }
        }
        catch (SQLException ex) {
            if (this.monitoringConn != null && !this.monitoringConn.isClosed()) {
                try {
                    this.monitoringConn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.monitoringConn = null;
            }
            throw ex;
        }
    }

    /*
     * Exception decompiling
     */
    private List<HostSpec> queryForLimitlessRouters(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<HostSpec> mapResultSetToHostSpecList(ResultSet resultSet) throws SQLException {
        ArrayList<HostSpec> hosts = new ArrayList<HostSpec>();
        while (resultSet.next()) {
            HostSpec host = this.createHost(resultSet);
            hosts.add(host);
        }
        return hosts;
    }

    private HostSpec createHost(ResultSet resultSet) throws SQLException {
        String hostName = resultSet.getString(1);
        float cpu = resultSet.getFloat(2);
        long weight = Math.round(10.0f - cpu * 10.0f);
        if (weight < 1L || weight > 10L) {
            weight = 1L;
            LOGGER.warning(() -> Messages.get("LimitlessRouterMonitor.invalidRouterLoad", new Object[]{hostName, Float.valueOf(cpu)}));
        }
        return new HostSpecBuilder(new SimpleHostAvailabilityStrategy()).host(hostName).port(this.hostSpec.getPort()).role(HostRole.WRITER).availability(HostAvailability.AVAILABLE).weight(weight).hostId(hostName).build();
    }

    private static /* synthetic */ String lambda$queryForLimitlessRouters$8(SQLException e) {
        return Messages.get("LimitlessRouterMonitor.getNetworkTimeoutError", new Object[]{e.getMessage()});
    }
}

