/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import software.amazon.jdbc.ConnectionPluginChainBuilder;
import software.amazon.jdbc.dialect.HostListProviderSupplier;
import software.amazon.jdbc.dialect.MysqlDialect;
import software.amazon.jdbc.hostlistprovider.AuroraHostListProvider;
import software.amazon.jdbc.hostlistprovider.monitoring.MonitoringRdsHostListProvider;

public class AuroraMysqlDialect
extends MysqlDialect {
    private static final String TOPOLOGY_QUERY = "SELECT SERVER_ID, CASE WHEN SESSION_ID = 'MASTER_SESSION_ID' THEN TRUE ELSE FALSE END, CPU, REPLICA_LAG_IN_MILLISECONDS, LAST_UPDATE_TIMESTAMP FROM information_schema.replica_host_status WHERE time_to_sec(timediff(now(), LAST_UPDATE_TIMESTAMP)) <= 300 OR SESSION_ID = 'MASTER_SESSION_ID' ";
    private static final String IS_WRITER_QUERY = "SELECT SERVER_ID FROM information_schema.replica_host_status WHERE SESSION_ID = 'MASTER_SESSION_ID' AND SERVER_ID = @@aurora_server_id";
    private static final String NODE_ID_QUERY = "SELECT @@aurora_server_id";
    private static final String IS_READER_QUERY = "SELECT @@innodb_read_only";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDialect(Connection connection) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery("SHOW VARIABLES LIKE 'aurora_version'");
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }

    @Override
    public List<String> getDialectUpdateCandidates() {
        return Collections.singletonList("rds-multi-az-mysql-cluster");
    }

    @Override
    public HostListProviderSupplier getHostListProvider() {
        return (properties, initialUrl, hostListProviderService, pluginService) -> {
            List<String> plugins = ConnectionPluginChainBuilder.getPluginCodes(properties);
            if (plugins.contains("failover2")) {
                return new MonitoringRdsHostListProvider(properties, initialUrl, hostListProviderService, TOPOLOGY_QUERY, NODE_ID_QUERY, IS_READER_QUERY, IS_WRITER_QUERY, pluginService);
            }
            return new AuroraHostListProvider(properties, initialUrl, hostListProviderService, TOPOLOGY_QUERY, NODE_ID_QUERY, IS_READER_QUERY);
        };
    }
}

