/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.targetdriverdialect.ConnectInfo;
import software.amazon.jdbc.targetdriverdialect.GenericTargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.PgDriverHelper;
import software.amazon.jdbc.util.PropertyUtils;

public class PgTargetDriverDialect
extends GenericTargetDriverDialect {
    private static final String DRIVER_CLASS_NAME = "org.postgresql.Driver";
    private static final String SIMPLE_DS_CLASS_NAME = "org.postgresql.ds.PGSimpleDataSource";
    private static final String POOLING_DS_CLASS_NAME = "org.postgresql.ds.PGPoolingDataSource";
    private static final String CP_DS_CLASS_NAME = "org.postgresql.ds.PGConnectionPoolDataSource";
    private static final Set<String> dataSourceClassMap = new HashSet<String>(Arrays.asList("org.postgresql.ds.PGSimpleDataSource", "org.postgresql.ds.PGPoolingDataSource", "org.postgresql.ds.PGConnectionPoolDataSource"));

    @Override
    public boolean isDialect(Driver driver) {
        return DRIVER_CLASS_NAME.equals(driver.getClass().getName());
    }

    @Override
    public boolean isDialect(String dataSourceClass) {
        return dataSourceClassMap.contains(dataSourceClass);
    }

    @Override
    public ConnectInfo prepareConnectInfo(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        String databaseName = PropertyDefinition.DATABASE.getString(props) != null ? PropertyDefinition.DATABASE.getString(props) : "";
        Boolean tcpKeepAlive = PropertyUtils.getBooleanPropertyValue(props, PropertyDefinition.TCP_KEEP_ALIVE);
        Integer loginTimeout = PropertyUtils.getIntegerPropertyValue(props, PropertyDefinition.LOGIN_TIMEOUT);
        Integer connectTimeout = PropertyUtils.getIntegerPropertyValue(props, PropertyDefinition.CONNECT_TIMEOUT);
        Integer socketTimeout = PropertyUtils.getIntegerPropertyValue(props, PropertyDefinition.SOCKET_TIMEOUT);
        PropertyDefinition.removeAllExceptCredentials(props);
        if (tcpKeepAlive != null) {
            props.setProperty("tcpKeepAlive", String.valueOf(tcpKeepAlive));
        }
        if (loginTimeout != null) {
            props.setProperty("loginTimeout", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(loginTimeout.intValue())));
        }
        if (connectTimeout != null) {
            props.setProperty("connectTimeout", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(connectTimeout.intValue())));
        }
        if (socketTimeout != null) {
            props.setProperty("socketTimeout", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(socketTimeout.intValue())));
        }
        String urlBuilder = protocol + hostSpec.getUrl() + databaseName;
        return new ConnectInfo(urlBuilder, props);
    }

    @Override
    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        PgDriverHelper helper = new PgDriverHelper();
        helper.prepareDataSource(dataSource, hostSpec, props);
    }

    @Override
    public boolean isDriverRegistered() throws SQLException {
        PgDriverHelper helper = new PgDriverHelper();
        return helper.isDriverRegistered();
    }

    @Override
    public void registerDriver() throws SQLException {
        PgDriverHelper helper = new PgDriverHelper();
        helper.registerDriver();
    }

    @Override
    public Set<String> getAllowedOnConnectionMethodNames() {
        return Collections.unmodifiableSet(new HashSet<String>(){
            {
                this.addAll(GenericTargetDriverDialect.ALLOWED_ON_CLOSED_METHODS);
                this.add("Statement.clearWarnings");
                this.add("Statement.getFetchSize");
                this.add("Statement.getMaxFieldSize");
                this.add("Statement.getResultSetType");
                this.add("Statement.isCloseOnCompletion");
                this.add("Statement.clearBatch");
                this.add("Statement.closeOnCompletion");
                this.add("Statement.getGeneratedKeys");
                this.add("Statement.getMaxRows");
                this.add("Statement.getMoreResults");
                this.add("Statement.getQueryTimeout");
                this.add("Statement.getResultSet");
                this.add("Statement.getResultSetConcurrency");
                this.add("Statement.getUpdateCount");
                this.add("Statement.getWarnings");
                this.add("Statement.addBatch");
                this.add("CallableStatement.getArray");
                this.add("CallableStatement.getBigDecimal");
                this.add("CallableStatement.getBoolean");
                this.add("CallableStatement.getByte");
                this.add("CallableStatement.getBytes");
                this.add("CallableStatement.getDate");
                this.add("CallableStatement.getDouble");
                this.add("CallableStatement.getFloat");
                this.add("CallableStatement.getInt");
                this.add("CallableStatement.getLong");
                this.add("CallableStatement.getObject");
                this.add("CallableStatement.getShort");
                this.add("CallableStatement.getSQLXML");
                this.add("CallableStatement.getTime");
                this.add("CallableStatement.getString");
                this.add("CallableStatement.getTimestamp");
                this.add("CallableStatement.wasNull");
                this.add("PreparedStatement.addBatch");
                this.add("PreparedStatement.clearParameters");
            }
        });
    }
}

