/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.exceptions;

import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.exceptions.ExceptionHandler;

public class ExceptionManager {
    protected static ExceptionHandler customHandler;

    public static void setCustomHandler(ExceptionHandler exceptionHandler) {
        customHandler = exceptionHandler;
    }

    public static void resetCustomHandler() {
        customHandler = null;
    }

    public boolean isLoginException(Dialect dialect, Throwable throwable) {
        ExceptionHandler handler = this.getHandler(dialect);
        return handler.isLoginException(throwable);
    }

    public boolean isLoginException(Dialect dialect, String sqlState) {
        ExceptionHandler handler = this.getHandler(dialect);
        return handler.isLoginException(sqlState);
    }

    public boolean isNetworkException(Dialect dialect, Throwable throwable) {
        ExceptionHandler handler = this.getHandler(dialect);
        return handler.isNetworkException(throwable);
    }

    public boolean isNetworkException(Dialect dialect, String sqlState) {
        ExceptionHandler handler = this.getHandler(dialect);
        return handler.isNetworkException(sqlState);
    }

    private ExceptionHandler getHandler(Dialect dialect) {
        return customHandler != null ? customHandler : dialect.getExceptionHandler();
    }
}

