/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSelector;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.RandomHostSelector;
import software.amazon.jdbc.RoundRobinHostSelector;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.exceptions.SQLLoginException;
import software.amazon.jdbc.targetdriverdialect.ConnectInfo;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;

public class DriverConnectionProvider
implements ConnectionProvider {
    private static final Logger LOGGER = Logger.getLogger(DriverConnectionProvider.class.getName());
    private static final Map<String, HostSelector> acceptedStrategies = Collections.unmodifiableMap(new HashMap<String, HostSelector>(){
        {
            this.put("random", new RandomHostSelector());
            this.put("roundRobin", new RoundRobinHostSelector());
        }
    });
    private final Driver driver;
    private final @NonNull String targetDriverClassName;

    public DriverConnectionProvider(Driver driver) {
        this.driver = driver;
        this.targetDriverClassName = driver.getClass().getName();
    }

    @Override
    public boolean acceptsUrl(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) {
        return true;
    }

    @Override
    public boolean acceptsStrategy(@NonNull HostRole role, @NonNull String strategy) {
        return acceptedStrategies.containsKey(strategy);
    }

    @Override
    public HostSpec getHostSpecByStrategy(@NonNull List<HostSpec> hosts, @NonNull HostRole role, @NonNull String strategy, @Nullable Properties props) throws SQLException {
        if (!acceptedStrategies.containsKey(strategy)) {
            throw new UnsupportedOperationException(Messages.get("ConnectionProvider.unsupportedHostSpecSelectorStrategy", new Object[]{strategy, DriverConnectionProvider.class}));
        }
        return acceptedStrategies.get(strategy).getHost(hosts, role, props);
    }

    @Override
    public Connection connect(@NonNull String protocol, @NonNull Dialect dialect, @NonNull TargetDriverDialect targetDriverDialect, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        LOGGER.finest(() -> PropertyUtils.logProperties(props, "Connecting with properties: \n"));
        Properties copy = PropertyUtils.copyProperties(props);
        dialect.prepareConnectProperties(copy, protocol, hostSpec);
        ConnectInfo connectInfo = targetDriverDialect.prepareConnectInfo(protocol, hostSpec, copy);
        LOGGER.finest(() -> "Connecting to " + connectInfo.url + PropertyUtils.logProperties(PropertyUtils.maskProperties(connectInfo.props), "\nwith properties: \n"));
        Connection conn = this.driver.connect(connectInfo.url, connectInfo.props);
        if (conn == null) {
            throw new SQLLoginException(Messages.get("ConnectionProvider.noConnection"));
        }
        return conn;
    }

    @Override
    public String getTargetName() {
        return this.targetDriverClassName;
    }
}

