/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.HikariPooledConnectionProvider;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSelector;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.SlidingExpirationCache;

public class LeastConnectionsHostSelector
implements HostSelector {
    public static final String STRATEGY_LEAST_CONNECTIONS = "leastConnections";
    private final SlidingExpirationCache<HikariPooledConnectionProvider.PoolKey, HikariDataSource> databasePools;

    public LeastConnectionsHostSelector(SlidingExpirationCache<HikariPooledConnectionProvider.PoolKey, HikariDataSource> databasePools) {
        this.databasePools = databasePools;
    }

    @Override
    public HostSpec getHost(@NonNull List<HostSpec> hosts, @NonNull HostRole role, @Nullable Properties props) throws SQLException {
        List eligibleHosts = hosts.stream().filter(hostSpec -> role.equals((Object)hostSpec.getRole())).sorted((hostSpec1, hostSpec2) -> this.getNumConnections((HostSpec)hostSpec1, this.databasePools) - this.getNumConnections((HostSpec)hostSpec2, this.databasePools)).collect(Collectors.toList());
        if (eligibleHosts.size() == 0) {
            throw new SQLException(Messages.get("HostSelector.noHostsMatchingRole", new Object[]{role}));
        }
        return (HostSpec)eligibleHosts.get(0);
    }

    private int getNumConnections(HostSpec hostSpec, SlidingExpirationCache<HikariPooledConnectionProvider.PoolKey, HikariDataSource> databasePools) {
        int numConnections = 0;
        String url = hostSpec.getUrl();
        for (Map.Entry<HikariPooledConnectionProvider.PoolKey, HikariDataSource> entry : databasePools.getEntries().entrySet()) {
            if (!url.equals(entry.getKey().getUrl())) continue;
            numConnections += entry.getValue().getHikariPoolMXBean().getActiveConnections();
        }
        return numConnections;
    }
}

