/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.mariadb.jdbc.Driver;
import org.mariadb.jdbc.MariaDbDataSource;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.util.ConnectionUrlBuilder;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;

public class MariadbDriverHelper {
    private static final Logger LOGGER = Logger.getLogger(MariadbDriverHelper.class.getName());
    private static final String LOGIN_TIMEOUT = "loginTimeout";
    private static final String DS_CLASS_NAME = MariaDbDataSource.class.getName();

    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        Integer loginTimeout;
        if (!(dataSource instanceof MariaDbDataSource)) {
            throw new SQLException(Messages.get("TargetDriverDialectManager.unexpectedClass", new Object[]{DS_CLASS_NAME, dataSource.getClass().getName()}));
        }
        MariaDbDataSource mariaDbDataSource = (MariaDbDataSource)dataSource;
        mariaDbDataSource.setUser(PropertyDefinition.USER.getString(props));
        mariaDbDataSource.setPassword(PropertyDefinition.PASSWORD.getString(props));
        String loginTimeoutValue = props.getProperty(LOGIN_TIMEOUT, null);
        if (loginTimeoutValue != null) {
            mariaDbDataSource.setLoginTimeout(Integer.parseInt(loginTimeoutValue));
            props.remove(LOGIN_TIMEOUT);
        }
        if ((loginTimeout = PropertyUtils.getIntegerPropertyValue(props, PropertyDefinition.LOGIN_TIMEOUT)) != null) {
            mariaDbDataSource.setLoginTimeout((int)TimeUnit.MILLISECONDS.toSeconds(loginTimeout.intValue()));
        }
        PropertyDefinition.removeAllExcept(props, PropertyDefinition.DATABASE.name, PropertyDefinition.TCP_KEEP_ALIVE.name, PropertyDefinition.CONNECT_TIMEOUT.name, PropertyDefinition.SOCKET_TIMEOUT.name);
        String finalUrl = ConnectionUrlBuilder.buildUrl(protocol, hostSpec, props);
        LOGGER.finest(() -> "Connecting to " + finalUrl);
        mariaDbDataSource.setUrl(finalUrl);
    }

    public boolean isDriverRegistered() throws SQLException {
        return Collections.list(DriverManager.getDrivers()).stream().filter(x -> x instanceof Driver).map(x -> true).findAny().orElse(false);
    }

    public void registerDriver() throws SQLException {
        try {
            DriverManager.registerDriver((java.sql.Driver)new Driver());
        }
        catch (SQLException e) {
            throw new SQLException(Messages.get("MariadbDriverHelper.canNotRegister"), e);
        }
    }
}

