/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.targetdriverdialect.ConnectInfo;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.util.ConnectionUrlBuilder;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;

public class GenericTargetDriverDialect
implements TargetDriverDialect {
    private static final Logger LOGGER = Logger.getLogger(GenericTargetDriverDialect.class.getName());

    @Override
    public boolean isDialect(Driver driver) {
        return true;
    }

    @Override
    public boolean isDialect(String dataSourceClass) {
        return true;
    }

    @Override
    public ConnectInfo prepareConnectInfo(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        String databaseName = PropertyDefinition.DATABASE.getString(props) != null ? PropertyDefinition.DATABASE.getString(props) : "";
        String urlBuilder = protocol + hostSpec.getUrl() + databaseName;
        PropertyDefinition.removeAllExceptCredentials(props);
        return new ConnectInfo(urlBuilder, props);
    }

    @Override
    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        String finalUrl = ConnectionUrlBuilder.buildUrl(protocol, hostSpec.getHost(), hostSpec.getPort(), PropertyDefinition.DATABASE.getString(props));
        LOGGER.finest(() -> "Connecting to " + finalUrl);
        props.setProperty("url", finalUrl);
        PropertyDefinition.removeAllExceptCredentials(props);
        LOGGER.finest(() -> PropertyUtils.logProperties(PropertyUtils.maskProperties(props), "Connecting with properties: \n"));
        if (!props.isEmpty()) {
            PropertyUtils.applyProperties(dataSource, props);
        }
    }

    @Override
    public boolean isDriverRegistered() throws SQLException {
        throw new SQLException(Messages.get("TargetDriverDialect.unsupported"));
    }

    @Override
    public void registerDriver() throws SQLException {
        throw new SQLException(Messages.get("TargetDriverDialect.unsupported"));
    }
}

