/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.HostListProvider;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.HostSpecBuilder;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.states.SessionDirtyFlag;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;

public interface PluginService
extends ExceptionHandler {
    public Connection getCurrentConnection();

    public HostSpec getCurrentHostSpec();

    public void setCurrentConnection(@NonNull Connection var1, @NonNull HostSpec var2) throws SQLException;

    public EnumSet<NodeChangeOptions> setCurrentConnection(@NonNull Connection var1, @NonNull HostSpec var2, @Nullable ConnectionPlugin var3) throws SQLException;

    public EnumSet<SessionDirtyFlag> getCurrentConnectionState();

    public void setCurrentConnectionState(SessionDirtyFlag var1);

    public void resetCurrentConnectionState(SessionDirtyFlag var1);

    public void resetCurrentConnectionStates();

    public boolean getAutoCommit();

    public void setAutoCommit(boolean var1);

    public List<HostSpec> getHosts();

    public HostSpec getInitialConnectionHostSpec();

    public boolean acceptsStrategy(HostRole var1, String var2) throws SQLException;

    public HostSpec getHostSpecByStrategy(HostRole var1, String var2) throws SQLException, UnsupportedOperationException;

    public HostRole getHostRole(Connection var1) throws SQLException;

    public void setAvailability(Set<String> var1, HostAvailability var2);

    public boolean isExplicitReadOnly();

    public boolean isReadOnly();

    public boolean isInTransaction();

    public HostListProvider getHostListProvider();

    public void refreshHostList() throws SQLException;

    public void refreshHostList(Connection var1) throws SQLException;

    public void forceRefreshHostList() throws SQLException;

    public void forceRefreshHostList(Connection var1) throws SQLException;

    public Connection connect(HostSpec var1, Properties var2) throws SQLException;

    public Connection forceConnect(HostSpec var1, Properties var2) throws SQLException;

    public Dialect getDialect();

    public TargetDriverDialect getTargetDriverDialect();

    public void updateDialect(@NonNull Connection var1) throws SQLException;

    public HostSpec identifyConnection(Connection var1) throws SQLException;

    public void fillAliases(Connection var1, HostSpec var2) throws SQLException;

    public HostSpecBuilder getHostSpecBuilder();

    public ConnectionProvider getConnectionProvider();

    public String getDriverProtocol();

    public Properties getProperties();

    public TelemetryFactory getTelemetryFactory();

    public String getTargetName();
}

