/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.JdbcRunnable;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;
import software.amazon.jdbc.wrapper.ArrayWrapper;
import software.amazon.jdbc.wrapper.BlobWrapper;
import software.amazon.jdbc.wrapper.CallableStatementWrapper;
import software.amazon.jdbc.wrapper.ClobWrapper;
import software.amazon.jdbc.wrapper.ConnectionWrapper;
import software.amazon.jdbc.wrapper.DatabaseMetaDataWrapper;
import software.amazon.jdbc.wrapper.NClobWrapper;
import software.amazon.jdbc.wrapper.ParameterMetaDataWrapper;
import software.amazon.jdbc.wrapper.PreparedStatementWrapper;
import software.amazon.jdbc.wrapper.RefWrapper;
import software.amazon.jdbc.wrapper.ResultSetMetaDataWrapper;
import software.amazon.jdbc.wrapper.ResultSetWrapper;
import software.amazon.jdbc.wrapper.SQLDataWrapper;
import software.amazon.jdbc.wrapper.SQLInputWrapper;
import software.amazon.jdbc.wrapper.SQLOutputWrapper;
import software.amazon.jdbc.wrapper.SQLTypeWrapper;
import software.amazon.jdbc.wrapper.SavepointWrapper;
import software.amazon.jdbc.wrapper.StatementWrapper;
import software.amazon.jdbc.wrapper.StructWrapper;

public class WrapperUtils {
    private static final ConcurrentMap<Class<?>, Class<?>[]> getImplementedInterfacesCache = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Boolean> isJdbcInterfaceCache = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<?>> availableWrappers = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(CallableStatement.class, CallableStatementWrapper.class);
            this.put(PreparedStatement.class, PreparedStatementWrapper.class);
            this.put(Statement.class, StatementWrapper.class);
            this.put(ResultSet.class, ResultSetWrapper.class);
            this.put(Array.class, ArrayWrapper.class);
            this.put(Blob.class, BlobWrapper.class);
            this.put(NClob.class, NClobWrapper.class);
            this.put(Clob.class, ClobWrapper.class);
            this.put(Ref.class, RefWrapper.class);
            this.put(Struct.class, StructWrapper.class);
            this.put(Savepoint.class, SavepointWrapper.class);
            this.put(DatabaseMetaData.class, DatabaseMetaDataWrapper.class);
            this.put(ParameterMetaData.class, ParameterMetaDataWrapper.class);
            this.put(ResultSetMetaData.class, ResultSetMetaDataWrapper.class);
            this.put(SQLData.class, SQLDataWrapper.class);
            this.put(SQLInput.class, SQLInputWrapper.class);
            this.put(SQLOutput.class, SQLOutputWrapper.class);
            this.put(SQLType.class, SQLTypeWrapper.class);
        }
    };
    private static final Set<Class<?>> allWrapperClasses = new HashSet<Class<?>>(){
        {
            this.add(ArrayWrapper.class);
            this.add(BlobWrapper.class);
            this.add(CallableStatementWrapper.class);
            this.add(ClobWrapper.class);
            this.add(ConnectionWrapper.class);
            this.add(DatabaseMetaDataWrapper.class);
            this.add(NClobWrapper.class);
            this.add(ParameterMetaDataWrapper.class);
            this.add(PreparedStatementWrapper.class);
            this.add(RefWrapper.class);
            this.add(ResultSetMetaDataWrapper.class);
            this.add(ResultSetWrapper.class);
            this.add(SavepointWrapper.class);
            this.add(SQLDataWrapper.class);
            this.add(SQLInputWrapper.class);
            this.add(SQLOutputWrapper.class);
            this.add(SQLTypeWrapper.class);
            this.add(StatementWrapper.class);
            this.add(StructWrapper.class);
        }
    };

    public static void runWithPlugins(ConnectionPluginManager pluginManager, Object methodInvokeOn, String methodName, JdbcRunnable<RuntimeException> jdbcMethodFunc, Object ... jdbcMethodArgs) {
        WrapperUtils.executeWithPlugins(Void.TYPE, RuntimeException.class, pluginManager, methodInvokeOn, methodName, () -> {
            jdbcMethodFunc.call();
            return null;
        }, jdbcMethodArgs);
    }

    public static <E extends Exception> void runWithPlugins(Class<E> exceptionClass, ConnectionPluginManager pluginManager, Object methodInvokeOn, String methodName, JdbcRunnable<E> jdbcMethodFunc, Object ... jdbcMethodArgs) throws E {
        WrapperUtils.executeWithPlugins(Void.TYPE, exceptionClass, pluginManager, methodInvokeOn, methodName, () -> {
            jdbcMethodFunc.call();
            return null;
        }, jdbcMethodArgs);
    }

    public static <T> T executeWithPlugins(Class<T> resultClass, ConnectionPluginManager pluginManager, Object methodInvokeOn, String methodName, JdbcCallable<T, RuntimeException> jdbcMethodFunc, Object ... jdbcMethodArgs) {
        pluginManager.lock();
        TelemetryFactory telemetryFactory = pluginManager.getTelemetryFactory();
        TelemetryContext context = null;
        try {
            T t;
            context = telemetryFactory.openTelemetryContext(methodName, TelemetryTraceLevel.TOP_LEVEL);
            context.setAttribute("jdbcCall", methodName);
            T result = pluginManager.execute(resultClass, RuntimeException.class, methodInvokeOn, methodName, jdbcMethodFunc, jdbcMethodArgs);
            context.setSuccess(true);
            try {
                t = WrapperUtils.wrapWithProxyIfNeeded(resultClass, result, pluginManager);
            }
            catch (InstantiationException e) {
                context.setSuccess(false);
                throw new RuntimeException(e);
            }
            return t;
        }
        finally {
            pluginManager.unlock();
            if (context != null) {
                context.closeContext();
            }
        }
    }

    public static <T, E extends Exception> T executeWithPlugins(Class<T> resultClass, Class<E> exceptionClass, ConnectionPluginManager pluginManager, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object ... jdbcMethodArgs) throws E {
        pluginManager.lock();
        TelemetryFactory telemetryFactory = pluginManager.getTelemetryFactory();
        TelemetryContext context = null;
        try {
            T t;
            context = telemetryFactory.openTelemetryContext(methodName, TelemetryTraceLevel.TOP_LEVEL);
            context.setAttribute("jdbcCall", methodName);
            T result = pluginManager.execute(resultClass, exceptionClass, methodInvokeOn, methodName, jdbcMethodFunc, jdbcMethodArgs);
            context.setSuccess(true);
            try {
                t = WrapperUtils.wrapWithProxyIfNeeded(resultClass, result, pluginManager);
            }
            catch (InstantiationException e) {
                context.setSuccess(false);
                throw new RuntimeException(e);
            }
            return t;
        }
        finally {
            pluginManager.unlock();
            if (context != null) {
                context.closeContext();
            }
        }
    }

    protected static <T> @Nullable T wrapWithProxyIfNeeded(Class<T> resultClass, @Nullable T toProxy, ConnectionPluginManager pluginManager) throws InstantiationException {
        if (toProxy == null) {
            return null;
        }
        if (toProxy instanceof RowId || toProxy instanceof SQLXML) {
            return toProxy;
        }
        if (allWrapperClasses.contains(toProxy.getClass())) {
            return toProxy;
        }
        Class<?> wrapperClass = availableWrappers.get(resultClass);
        if (wrapperClass != null) {
            return WrapperUtils.createInstance(wrapperClass, resultClass, new Class[]{resultClass, ConnectionPluginManager.class}, toProxy, pluginManager);
        }
        for (Class<?> iface : toProxy.getClass().getInterfaces()) {
            if (!WrapperUtils.isJdbcInterface(iface) || (wrapperClass = availableWrappers.get(iface)) == null) continue;
            return WrapperUtils.createInstance(wrapperClass, resultClass, new Class[]{iface, ConnectionPluginManager.class}, toProxy, pluginManager);
        }
        if (WrapperUtils.isJdbcInterface(toProxy.getClass())) {
            throw new RuntimeException(Messages.get("WrapperUtils.noWrapperClassExists", new Object[]{toProxy.getClass().getName()}));
        }
        return toProxy;
    }

    public static boolean isJdbcPackage(@Nullable String packageName) {
        return packageName != null && (packageName.startsWith("java.sql") || packageName.startsWith("javax.sql") || packageName.startsWith("org.postgresql"));
    }

    public static boolean isJdbcInterface(Class<?> clazz) {
        if (isJdbcInterfaceCache.containsKey(clazz)) {
            return (Boolean)isJdbcInterfaceCache.get(clazz);
        }
        if (clazz.isInterface()) {
            try {
                Package classPackage = clazz.getPackage();
                if (classPackage != null && WrapperUtils.isJdbcPackage(classPackage.getName())) {
                    isJdbcInterfaceCache.putIfAbsent(clazz, true);
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!WrapperUtils.isJdbcInterface(iface)) continue;
            isJdbcInterfaceCache.putIfAbsent(clazz, true);
            return true;
        }
        if (clazz.getSuperclass() != null && WrapperUtils.isJdbcInterface(clazz.getSuperclass())) {
            isJdbcInterfaceCache.putIfAbsent(clazz, true);
            return true;
        }
        isJdbcInterfaceCache.putIfAbsent(clazz, false);
        return false;
    }

    public static Class<?>[] getImplementedInterfaces(Class<?> clazz) {
        Class[] implementedInterfaces = (Class[])getImplementedInterfacesCache.get(clazz);
        if (implementedInterfaces != null) {
            return implementedInterfaces;
        }
        LinkedHashSet interfaces = new LinkedHashSet();
        Class<?> superClass = clazz;
        do {
            Collections.addAll(interfaces, superClass.getInterfaces());
        } while ((superClass = superClass.getSuperclass()) != null);
        implementedInterfaces = interfaces.toArray(new Class[0]);
        Class[] oldValue = getImplementedInterfacesCache.putIfAbsent(clazz, implementedInterfaces);
        if (oldValue != null) {
            implementedInterfaces = oldValue;
        }
        return implementedInterfaces;
    }

    public static <T> List<T> loadClasses(String extensionClassNames, Class<T> clazz, String errorMessageResourceKey) throws InstantiationException {
        LinkedList<T> instances = new LinkedList<T>();
        List<String> interceptorsToCreate = StringUtils.split(extensionClassNames, ",", true);
        String className = null;
        try {
            Iterator<String> iterator = interceptorsToCreate.iterator();
            while (iterator.hasNext()) {
                String value;
                className = value = iterator.next();
                T instance = WrapperUtils.createInstance(className, clazz, new Object[0]);
                instances.add(instance);
            }
        }
        catch (Throwable t) {
            throw new InstantiationException(Messages.get(errorMessageResourceKey, new Object[]{className}));
        }
        return instances;
    }

    public static <T> List<T> loadClasses(List<Class<? extends T>> extensionClassList, Class<T> resultClass, String errorMessageResourceKey) throws InstantiationException {
        LinkedList<T> instances = new LinkedList<T>();
        Class<T> lastClass = null;
        try {
            Iterator<Class<T>> iterator = extensionClassList.iterator();
            while (iterator.hasNext()) {
                Class<T> extensionClass;
                lastClass = extensionClass = iterator.next();
                T instance = WrapperUtils.createInstance(lastClass, resultClass, null, new Object[0]);
                instances.add(instance);
            }
        }
        catch (Throwable t) {
            throw new InstantiationException(Messages.get(errorMessageResourceKey, new Object[]{lastClass.getName()}));
        }
        return instances;
    }

    public static <T> T createInstance(Class<?> classToInstantiate, Class<T> resultClass, Class<?>[] constructorArgClasses, Object ... constructorArgs) throws InstantiationException {
        if (classToInstantiate == null) {
            throw new IllegalArgumentException("classToInstantiate");
        }
        if (resultClass == null) {
            throw new IllegalArgumentException("resultClass");
        }
        try {
            if (constructorArgs.length == 0) {
                return resultClass.cast(classToInstantiate.newInstance());
            }
            Class<?>[] argClasses = constructorArgClasses;
            if (argClasses == null) {
                argClasses = new Class[constructorArgs.length];
                for (int i = 0; i < constructorArgs.length; ++i) {
                    argClasses[i] = constructorArgs[i].getClass();
                }
            }
            Constructor<?> constructor = classToInstantiate.getConstructor(argClasses);
            return resultClass.cast(constructor.newInstance(constructorArgs));
        }
        catch (Exception e) {
            throw new InstantiationException(Messages.get("WrapperUtils.failedToInitializeClass", new Object[]{classToInstantiate.getName()}));
        }
    }

    public static <T> T createInstance(String className, Class<T> resultClass, Object ... constructorArgs) throws InstantiationException {
        Class<?> loaded;
        if (StringUtils.isNullOrEmpty(className)) {
            throw new IllegalArgumentException("className");
        }
        if (resultClass == null) {
            throw new IllegalArgumentException("resultClass");
        }
        try {
            loaded = Class.forName(className);
        }
        catch (Exception e) {
            throw new InstantiationException(Messages.get("WrapperUtils.failedToInitializeClass", new Object[]{className}));
        }
        return WrapperUtils.createInstance(loaded, resultClass, null, constructorArgs);
    }

    public static Object getFieldValue(Object target, String accessor) {
        if (target == null) {
            return null;
        }
        List<String> fieldNames = StringUtils.split(accessor, "\\.", true);
        Class<?> targetClass = target.getClass();
        for (String fieldName : fieldNames) {
            Object fieldValue;
            AccessibleObject field = null;
            while (targetClass != null && field == null) {
                try {
                    field = targetClass.getDeclaredField(fieldName);
                }
                catch (Exception ex) {
                    targetClass = targetClass.getSuperclass();
                }
            }
            if (field == null) {
                return null;
            }
            if (!field.isAccessible()) {
                ((Field)field).setAccessible(true);
            }
            try {
                fieldValue = ((Field)field).get(target);
            }
            catch (Exception ex) {
                return null;
            }
            if (fieldValue == null) {
                return null;
            }
            target = fieldValue;
            targetClass = target.getClass();
        }
        return target;
    }

    public static Connection getConnectionFromSqlObject(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            if (obj instanceof Connection) {
                return (Connection)obj;
            }
            if (obj instanceof Statement) {
                Statement stmt = (Statement)obj;
                return !stmt.isClosed() ? stmt.getConnection() : null;
            }
            if (obj instanceof ResultSet) {
                ResultSet rs = (ResultSet)obj;
                Statement stmt = rs.getStatement();
                return stmt != null && !stmt.isClosed() ? stmt.getConnection() : null;
            }
        }
        catch (UnsupportedOperationException | SQLException exception) {
            // empty catch block
        }
        return null;
    }

    public static <E extends Exception> E wrapExceptionIfNeeded(Class<E> exceptionClass, Throwable exception) {
        Exception result;
        if (exceptionClass.isAssignableFrom(exception.getClass())) {
            return (E)((Exception)exceptionClass.cast(exception));
        }
        try {
            result = (Exception)WrapperUtils.createInstance(exceptionClass, exceptionClass, new Class[]{Throwable.class}, exception);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        return (E)((Exception)exceptionClass.cast(result));
    }
}

