/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.targetdriverdialect.ConnectInfo;
import software.amazon.jdbc.targetdriverdialect.GenericTargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.MysqlConnectorJDriverHelper;

public class MysqlConnectorJTargetDriverDialect
extends GenericTargetDriverDialect {
    private static final String DRIVER_CLASS_NAME = "com.mysql.cj.jdbc.Driver";
    private static final String DS_CLASS_NAME = "com.mysql.cj.jdbc.MysqlDataSource";
    private static final String CP_DS_CLASS_NAME = "com.mysql.cj.jdbc.MysqlConnectionPoolDataSource";

    @Override
    public boolean isDialect(Driver driver) {
        return DRIVER_CLASS_NAME.equals(driver.getClass().getName());
    }

    @Override
    public boolean isDialect(String dataSourceClass) {
        return DS_CLASS_NAME.equals(dataSourceClass) || CP_DS_CLASS_NAME.equals(dataSourceClass);
    }

    @Override
    public ConnectInfo prepareConnectInfo(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        String databaseName = PropertyDefinition.DATABASE.getString(props) != null ? PropertyDefinition.DATABASE.getString(props) : "";
        String urlBuilder = protocol + hostSpec.getUrl() + databaseName;
        PropertyDefinition.removeAllExcept(props, PropertyDefinition.USER.name, PropertyDefinition.PASSWORD.name, PropertyDefinition.TCP_KEEP_ALIVE.name, PropertyDefinition.SOCKET_TIMEOUT.name, PropertyDefinition.CONNECT_TIMEOUT.name);
        return new ConnectInfo(urlBuilder, props);
    }

    @Override
    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        MysqlConnectorJDriverHelper helper = new MysqlConnectorJDriverHelper();
        helper.prepareDataSource(dataSource, hostSpec, props);
    }

    @Override
    public boolean isDriverRegistered() throws SQLException {
        MysqlConnectorJDriverHelper helper = new MysqlConnectorJDriverHelper();
        return helper.isDriverRegistered();
    }

    @Override
    public void registerDriver() throws SQLException {
        MysqlConnectorJDriverHelper helper = new MysqlConnectorJDriverHelper();
        helper.registerDriver();
    }
}

