/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.OldConnectionSuggestedAction;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.cleanup.CanReleaseResources;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.efm.MonitorConnectionContext;
import software.amazon.jdbc.plugin.efm.MonitorService;
import software.amazon.jdbc.plugin.efm.MonitorServiceImpl;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.SubscribedMethodHelper;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;

public class HostMonitoringConnectionPlugin
extends AbstractConnectionPlugin
implements CanReleaseResources {
    private static final Logger LOGGER = Logger.getLogger(HostMonitoringConnectionPlugin.class.getName());
    public static final AwsWrapperProperty FAILURE_DETECTION_ENABLED = new AwsWrapperProperty("failureDetectionEnabled", "true", "Enable failure detection logic (aka node monitoring thread).");
    public static final AwsWrapperProperty FAILURE_DETECTION_TIME = new AwsWrapperProperty("failureDetectionTime", "30000", "Interval in millis between sending SQL to the server and the first probe to database node.");
    public static final AwsWrapperProperty FAILURE_DETECTION_INTERVAL = new AwsWrapperProperty("failureDetectionInterval", "5000", "Interval in millis between probes to database node.");
    public static final AwsWrapperProperty FAILURE_DETECTION_COUNT = new AwsWrapperProperty("failureDetectionCount", "3", "Number of failed connection checks before considering database node unhealthy.");
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("*")));
    protected @NonNull Properties properties;
    private final @NonNull Supplier<MonitorService> monitorServiceSupplier;
    private final @NonNull PluginService pluginService;
    private final @NonNull TelemetryFactory telemetryFactory;
    private MonitorService monitorService;
    private final RdsUtils rdsHelper;
    private HostSpec monitoringHostSpec;

    public HostMonitoringConnectionPlugin(@NonNull PluginService pluginService, @NonNull Properties properties) {
        this(pluginService, properties, () -> new MonitorServiceImpl(pluginService), new RdsUtils());
    }

    HostMonitoringConnectionPlugin(@NonNull PluginService pluginService, @NonNull Properties properties, @NonNull Supplier<MonitorService> monitorServiceSupplier, RdsUtils rdsHelper) {
        if (pluginService == null) {
            throw new IllegalArgumentException("pluginService");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties");
        }
        if (monitorServiceSupplier == null) {
            throw new IllegalArgumentException("monitorServiceSupplier");
        }
        this.pluginService = pluginService;
        this.telemetryFactory = pluginService.getTelemetryFactory();
        this.properties = properties;
        this.monitorServiceSupplier = monitorServiceSupplier;
        this.rdsHelper = rdsHelper;
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        T result;
        block18: {
            MonitorConnectionContext monitorConnectionContext;
            boolean isEnabled = FAILURE_DETECTION_ENABLED.getBoolean(this.properties);
            if (!isEnabled || !SubscribedMethodHelper.NETWORK_BOUND_METHODS.contains(methodName)) {
                return jdbcMethodFunc.call();
            }
            int failureDetectionTimeMillis = FAILURE_DETECTION_TIME.getInteger(this.properties);
            int failureDetectionIntervalMillis = FAILURE_DETECTION_INTERVAL.getInteger(this.properties);
            int failureDetectionCount = FAILURE_DETECTION_COUNT.getInteger(this.properties);
            this.initMonitorService();
            MonitorConnectionContext monitorContext = null;
            try {
                LOGGER.finest(() -> Messages.get("HostMonitoringConnectionPlugin.activatedMonitoring", new Object[]{methodName}));
                HostSpec monitoringHostSpec = this.getMonitoringHostSpec();
                monitorContext = this.monitorService.startMonitoring(this.pluginService.getCurrentConnection(), monitoringHostSpec.asAliases(), monitoringHostSpec, this.properties, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount);
                result = jdbcMethodFunc.call();
                if (monitorContext == null) break block18;
                monitorConnectionContext = monitorContext;
            }
            catch (Throwable throwable) {
                if (monitorContext != null) {
                    MonitorConnectionContext monitorConnectionContext2 = monitorContext;
                    synchronized (monitorConnectionContext2) {
                        this.monitorService.stopMonitoring(monitorContext);
                        if (monitorContext.isNodeUnhealthy()) {
                            boolean isConnectionClosed;
                            this.pluginService.setAvailability(this.getMonitoringHostSpec().asAliases(), HostAvailability.NOT_AVAILABLE);
                            try {
                                isConnectionClosed = this.pluginService.getCurrentConnection().isClosed();
                            }
                            catch (SQLException e) {
                                throw this.castException(exceptionClass, e);
                            }
                            if (!isConnectionClosed) {
                                this.abortConnection();
                                throw this.castException(exceptionClass, new SQLException(Messages.get("HostMonitoringConnectionPlugin.unavailableNode", new Object[]{this.pluginService.getCurrentHostSpec().asAlias()})));
                            }
                        }
                    }
                    LOGGER.finest(() -> Messages.get("HostMonitoringConnectionPlugin.monitoringDeactivated", new Object[]{methodName}));
                }
                throw throwable;
            }
            synchronized (monitorConnectionContext) {
                this.monitorService.stopMonitoring(monitorContext);
                if (monitorContext.isNodeUnhealthy()) {
                    boolean isConnectionClosed;
                    this.pluginService.setAvailability(this.getMonitoringHostSpec().asAliases(), HostAvailability.NOT_AVAILABLE);
                    try {
                        isConnectionClosed = this.pluginService.getCurrentConnection().isClosed();
                    }
                    catch (SQLException e) {
                        throw this.castException(exceptionClass, e);
                    }
                    if (!isConnectionClosed) {
                        this.abortConnection();
                        throw this.castException(exceptionClass, new SQLException(Messages.get("HostMonitoringConnectionPlugin.unavailableNode", new Object[]{this.pluginService.getCurrentHostSpec().asAlias()})));
                    }
                }
            }
            LOGGER.finest(() -> Messages.get("HostMonitoringConnectionPlugin.monitoringDeactivated", new Object[]{methodName}));
        }
        return result;
    }

    private <E extends Exception> E castException(Class<E> exceptionClass, SQLException exceptionToCast) {
        if (exceptionClass.isAssignableFrom(SQLException.class)) {
            return (E)((Exception)exceptionClass.cast(exceptionToCast));
        }
        return (E)((Exception)exceptionClass.cast(new RuntimeException(exceptionToCast)));
    }

    void abortConnection() {
        try {
            this.pluginService.getCurrentConnection().close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void initMonitorService() {
        if (this.monitorService == null) {
            this.monitorService = this.monitorServiceSupplier.get();
        }
    }

    @Override
    public void releaseResources() {
        if (this.monitorService != null) {
            this.monitorService.releaseResources();
        }
        this.monitorService = null;
    }

    @Override
    public OldConnectionSuggestedAction notifyConnectionChanged(EnumSet<NodeChangeOptions> changes) {
        if ((changes.contains((Object)NodeChangeOptions.WENT_DOWN) || changes.contains((Object)NodeChangeOptions.NODE_DELETED)) && !this.getMonitoringHostSpec().asAliases().isEmpty()) {
            this.monitorService.stopMonitoringForAllConnections(this.getMonitoringHostSpec().asAliases());
        }
        this.monitoringHostSpec = null;
        return OldConnectionSuggestedAction.NO_OPINION;
    }

    @Override
    public Connection connect(@NonNull String driverProtocol, @NonNull HostSpec hostSpec, @NonNull Properties props, boolean isInitialConnection, @NonNull JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        return this.connectInternal(driverProtocol, hostSpec, connectFunc);
    }

    private Connection connectInternal(String driverProtocol, HostSpec hostSpec, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        RdsUrlType type;
        Connection conn = connectFunc.call();
        if (conn != null && (type = this.rdsHelper.identifyRdsType(hostSpec.getHost())).isRdsCluster()) {
            hostSpec.resetAliases();
            this.pluginService.fillAliases(conn, hostSpec);
        }
        return conn;
    }

    @Override
    public Connection forceConnect(@NonNull String driverProtocol, @NonNull HostSpec hostSpec, @NonNull Properties props, boolean isInitialConnection, @NonNull JdbcCallable<Connection, SQLException> forceConnectFunc) throws SQLException {
        return this.connectInternal(driverProtocol, hostSpec, forceConnectFunc);
    }

    public HostSpec getMonitoringHostSpec() {
        if (this.monitoringHostSpec == null) {
            this.monitoringHostSpec = this.pluginService.getCurrentHostSpec();
            RdsUrlType rdsUrlType = this.rdsHelper.identifyRdsType(this.monitoringHostSpec.getUrl());
            try {
                if (rdsUrlType.isRdsCluster()) {
                    LOGGER.finest("Monitoring HostSpec is associated with a cluster endpoint, plugin needs to identify the cluster connection.");
                    this.monitoringHostSpec = this.pluginService.identifyConnection(this.pluginService.getCurrentConnection());
                    if (this.monitoringHostSpec == null) {
                        throw new RuntimeException(Messages.get("HostMonitoringConnectionPlugin.unableToIdentifyConnection", new Object[]{this.pluginService.getCurrentHostSpec().getHost(), this.pluginService.getHostListProvider()}));
                    }
                    this.pluginService.fillAliases(this.pluginService.getCurrentConnection(), this.monitoringHostSpec);
                }
            }
            catch (SQLException e) {
                LOGGER.finest(Messages.get("HostMonitoringConnectionPlugin.errorIdentifyingConnection", new Object[]{e}));
                throw new RuntimeException(e);
            }
        }
        return this.monitoringHostSpec;
    }

    static {
        PropertyDefinition.registerPluginProperties(HostMonitoringConnectionPlugin.class);
        PropertyDefinition.registerPluginProperties("monitoring-");
    }
}

