/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.dialect.HostListProviderSupplier;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.MySQLExceptionHandler;
import software.amazon.jdbc.hostlistprovider.ConnectionStringHostListProvider;

public class MysqlDialect
implements Dialect {
    private static final List<String> dialectUpdateCandidates = Arrays.asList("aurora-mysql", "rds-multi-az-mysql-cluster", "rds-mysql");
    private static MySQLExceptionHandler mySQLExceptionHandler;

    @Override
    public int getDefaultPort() {
        return 3306;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        if (mySQLExceptionHandler == null) {
            mySQLExceptionHandler = new MySQLExceptionHandler();
        }
        return mySQLExceptionHandler;
    }

    @Override
    public String getHostAliasQuery() {
        return "SELECT CONCAT(@@hostname, ':', @@port)";
    }

    @Override
    public String getServerVersionQuery() {
        return "SHOW VARIABLES LIKE 'version_comment'";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDialect(Connection connection) {
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(this.getServerVersionQuery());){
            block26: while (true) {
                if (!rs.next()) return false;
                int columnCount = rs.getMetaData().getColumnCount();
                int i = 1;
                while (true) {
                    if (i > columnCount) continue block26;
                    String columnValue = rs.getString(i);
                    if (columnValue != null && columnValue.toLowerCase().contains("mysql")) {
                        boolean bl = true;
                        return bl;
                    }
                    ++i;
                }
                break;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public List<String> getDialectUpdateCandidates() {
        return dialectUpdateCandidates;
    }

    @Override
    public HostListProviderSupplier getHostListProvider() {
        return ConnectionStringHostListProvider::new;
    }

    @Override
    public void prepareConnectProperties(@NonNull Properties connectProperties, @NonNull String protocol, @NonNull HostSpec hostSpec) {
    }
}

