/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.telemetry;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import software.amazon.jdbc.util.telemetry.GaugeCallable;
import software.amazon.jdbc.util.telemetry.OpenTelemetryContext;
import software.amazon.jdbc.util.telemetry.OpenTelemetryCounter;
import software.amazon.jdbc.util.telemetry.OpenTelemetryGauge;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryGauge;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class OpenTelemetryFactory
implements TelemetryFactory {
    private static final String INSTRUMENTATION_NAME = "aws-advanced-jdbc-wrapper";
    private static OpenTelemetry openTelemetry;
    private static Tracer tracer;
    private static Meter meter;
    private static final Object mutex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OpenTelemetry getOpenTelemetry() {
        if (openTelemetry == null) {
            Object object = mutex;
            synchronized (object) {
                if (openTelemetry == null) {
                    openTelemetry = GlobalOpenTelemetry.get();
                }
            }
        }
        return openTelemetry;
    }

    @Override
    public TelemetryContext openTelemetryContext(String name, TelemetryTraceLevel traceLevel) {
        tracer = OpenTelemetryFactory.getOpenTelemetry().getTracer(INSTRUMENTATION_NAME);
        return new OpenTelemetryContext(tracer, name, traceLevel);
    }

    @Override
    public void postCopy(TelemetryContext telemetryContext, TelemetryTraceLevel traceLevel) {
        if (!(telemetryContext instanceof OpenTelemetryContext)) {
            throw new RuntimeException("Wrong parameter type: " + telemetryContext.getClass().getName());
        }
        OpenTelemetryContext.postCopy((OpenTelemetryContext)telemetryContext, traceLevel);
    }

    @Override
    public TelemetryCounter createCounter(String name) {
        meter = OpenTelemetryFactory.getOpenTelemetry().getMeter(INSTRUMENTATION_NAME);
        return new OpenTelemetryCounter(meter, name);
    }

    @Override
    public TelemetryGauge createGauge(String name, GaugeCallable<Long> callback) {
        meter = OpenTelemetryFactory.getOpenTelemetry().getMeter(INSTRUMENTATION_NAME);
        return new OpenTelemetryGauge(meter, name, callback);
    }

    static {
        mutex = new Object();
    }
}

