/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.dialect.HostListProviderSupplier;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.PgExceptionHandler;
import software.amazon.jdbc.hostlistprovider.ConnectionStringHostListProvider;

public class PgDialect
implements Dialect {
    private static final List<String> dialectUpdateCandidates = Arrays.asList("aurora-pg", "rds-pg");
    private static PgExceptionHandler pgExceptionHandler;

    @Override
    public int getDefaultPort() {
        return 5432;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        if (pgExceptionHandler == null) {
            pgExceptionHandler = new PgExceptionHandler();
        }
        return pgExceptionHandler;
    }

    @Override
    public String getHostAliasQuery() {
        return "SELECT CONCAT(inet_server_addr(), ':', inet_server_port())";
    }

    @Override
    public String getServerVersionQuery() {
        return "SELECT 'version', VERSION()";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDialect(Connection connection) {
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT 1 FROM pg_proc LIMIT 1");){
            if (!rs.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public List<String> getDialectUpdateCandidates() {
        return dialectUpdateCandidates;
    }

    @Override
    public HostListProviderSupplier getHostListProvider() {
        return ConnectionStringHostListProvider::new;
    }
}

