/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import com.mysql.cj.jdbc.MysqlDataSource;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;

public class MysqlConnectorJDataSourceHelper {
    private static final Logger LOGGER = Logger.getLogger(MysqlConnectorJDataSourceHelper.class.getName());

    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        if (!(dataSource instanceof MysqlDataSource)) {
            throw new SQLException(Messages.get("TargetDriverDialectManager.unexpectedClass", new Object[]{"com.mysql.cj.jdbc.MysqlDataSource", dataSource.getClass().getName()}));
        }
        MysqlDataSource baseDataSource = (MysqlDataSource)dataSource;
        baseDataSource.setDatabaseName(PropertyDefinition.DATABASE.getString(props));
        baseDataSource.setUser(PropertyDefinition.USER.getString(props));
        baseDataSource.setPassword(PropertyDefinition.PASSWORD.getString(props));
        baseDataSource.setServerName(hostSpec.getHost());
        if (hostSpec.isPortSpecified()) {
            baseDataSource.setPortNumber(hostSpec.getPort());
        }
        PropertyDefinition.removeAll(props);
        PropertyUtils.applyProperties(dataSource, props);
    }
}

