/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HikariPoolConfigurator;
import software.amazon.jdbc.HikariPoolMapping;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PooledConnectionProvider;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.cleanup.CanReleaseResources;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.util.HikariCPSQLException;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.SlidingExpirationCache;
import software.amazon.jdbc.util.StringUtils;

public class HikariPooledConnectionProvider
implements PooledConnectionProvider,
CanReleaseResources {
    private static final Logger LOGGER = Logger.getLogger(HikariPooledConnectionProvider.class.getName());
    private static final String LEAST_CONNECTIONS_STRATEGY = "leastConnections";
    private static final RdsUtils rdsUtils = new RdsUtils();
    private static SlidingExpirationCache<PoolKey, HikariDataSource> databasePools = new SlidingExpirationCache(hikariDataSource -> hikariDataSource.getHikariPoolMXBean().getActiveConnections() == 0, HikariDataSource::close);
    private static long poolExpirationCheckNanos = TimeUnit.MINUTES.toNanos(30L);
    private final HikariPoolConfigurator poolConfigurator;
    private final HikariPoolMapping poolMapping;

    public HikariPooledConnectionProvider(HikariPoolConfigurator hikariPoolConfigurator) {
        this(hikariPoolConfigurator, null);
    }

    public HikariPooledConnectionProvider(HikariPoolConfigurator hikariPoolConfigurator, HikariPoolMapping mapping) {
        this.poolConfigurator = hikariPoolConfigurator;
        this.poolMapping = mapping;
    }

    public HikariPooledConnectionProvider(HikariPoolConfigurator hikariPoolConfigurator, HikariPoolMapping mapping, long poolExpirationNanos, long poolCleanupNanos) {
        this.poolConfigurator = hikariPoolConfigurator;
        this.poolMapping = mapping;
        poolExpirationCheckNanos = poolExpirationNanos;
        databasePools.setCleanupIntervalNanos(poolCleanupNanos);
    }

    @Override
    public boolean acceptsUrl(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) {
        RdsUrlType urlType = rdsUtils.identifyRdsType(hostSpec.getHost());
        return RdsUrlType.RDS_INSTANCE.equals((Object)urlType);
    }

    @Override
    public boolean acceptsStrategy(@NonNull HostRole role, @NonNull String strategy) {
        return LEAST_CONNECTIONS_STRATEGY.equals(strategy);
    }

    @Override
    public HostSpec getHostSpecByStrategy(@NonNull List<HostSpec> hosts, @NonNull HostRole role, @NonNull String strategy) throws SQLException {
        if (!LEAST_CONNECTIONS_STRATEGY.equals(strategy)) {
            throw new UnsupportedOperationException(Messages.get("ConnectionProvider.unsupportedHostSpecSelectorStrategy", new Object[]{strategy, HikariPooledConnectionProvider.class}));
        }
        List eligibleHosts = hosts.stream().filter(hostSpec -> role.equals((Object)hostSpec.getRole())).sorted((hostSpec1, hostSpec2) -> this.getNumConnections((HostSpec)hostSpec1) - this.getNumConnections((HostSpec)hostSpec2)).collect(Collectors.toList());
        if (eligibleHosts.size() == 0) {
            throw new SQLException(Messages.get("HostSelector.noHostsMatchingRole", new Object[]{role}));
        }
        return (HostSpec)eligibleHosts.get(0);
    }

    private int getNumConnections(HostSpec hostSpec) {
        int numConnections = 0;
        String url = hostSpec.getUrl();
        for (Map.Entry<PoolKey, HikariDataSource> entry : databasePools.getEntries().entrySet()) {
            if (!url.equals(entry.getKey().url)) continue;
            numConnections += entry.getValue().getHikariPoolMXBean().getActiveConnections();
        }
        return numConnections;
    }

    @Override
    public Connection connect(@NonNull String protocol, @NonNull Dialect dialect, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        HikariDataSource ds = databasePools.computeIfAbsent(new PoolKey(hostSpec.getUrl(), this.getPoolKey(hostSpec, props)), lambdaPoolKey -> this.createHikariDataSource(protocol, hostSpec, props), poolExpirationCheckNanos);
        ds.setPassword(props.getProperty(PropertyDefinition.PASSWORD.name));
        return ds.getConnection();
    }

    @Override
    @Deprecated
    public Connection connect(@NonNull String url, @NonNull Properties props) throws SQLException {
        return null;
    }

    private String getPoolKey(HostSpec hostSpec, Properties props) {
        if (this.poolMapping != null) {
            return this.poolMapping.getKey(hostSpec, props);
        }
        String user = props.getProperty(PropertyDefinition.USER.name);
        return user == null ? "" : user;
    }

    @Override
    public void releaseResources() {
        databasePools.getEntries().forEach((poolKey, pool) -> {
            if (!pool.isClosed()) {
                pool.close();
            }
        });
        databasePools.clear();
    }

    protected void configurePool(HikariConfig config, String protocol, HostSpec hostSpec, Properties connectionProps) {
        StringBuilder urlBuilder = new StringBuilder().append(protocol).append(hostSpec.getUrl());
        String db = PropertyDefinition.DATABASE.getString(connectionProps);
        if (!StringUtils.isNullOrEmpty(db)) {
            urlBuilder.append(db);
        }
        StringJoiner propsJoiner = new StringJoiner("&");
        connectionProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (!PropertyDefinition.PASSWORD.name.equals(k) && !PropertyDefinition.USER.name.equals(k)) {
                propsJoiner.add(k + "=" + v);
            }
        }));
        urlBuilder.append("?").append(propsJoiner);
        config.setJdbcUrl(urlBuilder.toString());
        config.setExceptionOverrideClassName(HikariCPSQLException.class.getName());
        String user = connectionProps.getProperty(PropertyDefinition.USER.name);
        String password = connectionProps.getProperty(PropertyDefinition.PASSWORD.name);
        if (user != null) {
            config.setUsername(user);
        }
        if (password != null) {
            config.setPassword(password);
        }
    }

    public int getHostCount() {
        return databasePools.size();
    }

    public Set<String> getHosts() {
        return Collections.unmodifiableSet(databasePools.getEntries().keySet().stream().map(poolKey -> ((PoolKey)poolKey).url).collect(Collectors.toSet()));
    }

    public Set<PoolKey> getKeys() {
        return databasePools.getEntries().keySet();
    }

    public void logConnections() {
        LOGGER.finest(() -> {
            StringBuilder builder = new StringBuilder();
            databasePools.getEntries().forEach((key, dataSource) -> {
                builder.append("\t[ ");
                builder.append(key).append(":");
                builder.append("\n\t {");
                builder.append("\n\t\t").append(dataSource);
                builder.append("\n\t }\n");
                builder.append("\t");
            });
            return String.format("Hikari Pooled Connection: \n[\n%s\n]", builder);
        });
    }

    HikariDataSource createHikariDataSource(String protocol, HostSpec hostSpec, Properties props) {
        HikariConfig config = this.poolConfigurator.configurePool(hostSpec, props);
        this.configurePool(config, protocol, hostSpec, props);
        return new HikariDataSource(config);
    }

    void setDatabasePools(SlidingExpirationCache<PoolKey, HikariDataSource> connectionPools) {
        databasePools = connectionPools;
    }

    public static class PoolKey {
        private final @NonNull String url;
        private final @NonNull String extraKey;

        public PoolKey(@NonNull String url, @NonNull String extraKey) {
            this.url = url;
            this.extraKey = extraKey;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode()) + (this.extraKey == null ? 0 : this.extraKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PoolKey other = (PoolKey)obj;
            return this.url.equals(other.url) && this.extraKey.equals(other.extraKey);
        }

        public String toString() {
            return "PoolKey [url=" + this.url + ", extraKey=" + this.extraKey + "]";
        }
    }
}

